/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.motion.charts;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.util.SimpleObservable;

public class Range
extends SimpleObservable {
    private double min;
    private double max;

    public Range(double d, double d2) {
        this.min = d;
        this.max = d2;
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double d) {
        if (this.min != d) {
            this.min = d;
            this.notifyObservers();
        }
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double d) {
        if (this.max != d) {
            this.max = d;
            this.notifyObservers();
        }
    }

    public double clamp(double d) {
        return MathUtil.clamp(this.min, d, this.max);
    }

    public void stepTowardsRange(double d, double d2, double d3) {
        double d4 = d - this.min;
        double d5 = d2 - this.max;
        double d6 = this.min + d3 * MathUtil.signum(d4);
        double d7 = this.max + d3 * MathUtil.signum(d5);
        if (Math.abs(d7 - d2) <= d3) {
            d7 = d2;
        }
        if (Math.abs(d6 - d) <= d3) {
            d6 = d;
        }
        this.setMin(d6);
        this.setMax(d7);
    }
}

