/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.simsharing.logs;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.WriteResult;
import edu.colorado.phet.common.phetcommon.simsharing.Log;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingMessage;
import edu.colorado.phet.common.phetcommon.simsharing.messages.Parameter;
import edu.colorado.phet.common.phetcommon.util.logging.LoggingUtils;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class MongoLog
implements Log {
    private static final Logger LOGGER = LoggingUtils.getLogger(MongoLog.class.getCanonicalName());
    private Mongo mongo;
    public static String HOST_IP_ADDRESS = System.getProperty("sim-event-data-collection-server-host-ip-address", "128.138.145.107");
    public static int PORT = Integer.parseInt(System.getProperty("sim-event-data-collection-server-host-port", "44100"));
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    private final DBCollection collection;
    private int failureCount = 0;
    public static final String MER = "meR".toLowerCase();

    public MongoLog(String string, String string2) throws UnknownHostException {
        this.mongo = new Mongo(HOST_IP_ADDRESS, PORT);
        DB dB = this.mongo.getDB(string2);
        try {
            boolean bl = dB.authenticate("phetsimclient", (MER + "8zkamme" + "" + 8 + "ss0O88723otbubaoue").toCharArray());
            if (!bl) {
                new RuntimeException("Authentication failed").printStackTrace();
            }
        }
        catch (MongoException.Network network) {
            LOGGER.warning("Failed to connect to mongo during authentication.  Perhaps there is no internet connection.");
        }
        this.collection = dB.getCollection(string);
        LOGGER.info("turning off MongoDB loggers");
        Enumeration<String> enumeration = LogManager.getLogManager().getLoggerNames();
        while (enumeration.hasMoreElements()) {
            String string3 = enumeration.nextElement();
            if (!string3.startsWith("com.mongodb")) continue;
            LogManager.getLogManager().getLogger(string3).setLevel(Level.OFF);
        }
    }

    public void addMessage(final SimSharingMessage simSharingMessage) throws IOException {
        this.executor.execute(new Runnable(){

            public void run() {
                BasicDBObject basicDBObject = new BasicDBObject(){
                    {
                        this.put("time", (Object)(simSharingMessage.time + ""));
                        this.put("messageType", (Object)simSharingMessage.messageType.toString());
                        this.put("component", (Object)simSharingMessage.component.toString());
                        this.put("componentType", (Object)simSharingMessage.componentType.toString());
                        this.put("action", (Object)simSharingMessage.action.toString());
                        this.put("parameters", (Object)new BasicDBObject(){
                            {
                                for (Parameter parameter : simSharingMessage.parameters) {
                                    this.put(parameter.name.toString(), (Object)(parameter.value == null ? "null" : parameter.value.toString()));
                                }
                            }
                        });
                    }
                };
                try {
                    if (MongoLog.this.failureCount < 3) {
                        WriteResult writeResult = MongoLog.this.collection.insert(basicDBObject);
                    }
                }
                catch (RuntimeException runtimeException) {
                    MongoLog.this.failureCount++;
                    LOGGER.warning(MongoLog.this.failureCount + " failures sending to Mongo server, error=" + runtimeException.getMessage());
                }
            }
        });
    }

    public String getName() {
        return "MongoDB Server @ " + this.mongo.getAddress();
    }

    public void shutdown() {
        this.executor.shutdown();
        try {
            boolean bl = this.executor.awaitTermination(1L, TimeUnit.SECONDS);
            LOGGER.info("MongoLog.executor awaitTermination, success = " + bl);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }
}

