/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes;

import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserActions;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class MinimizeMaximizeNode
extends PNode {
    private static final Font DEFAULT_FONT = new PhetFont();
    private static final Color DEFAULT_TEXT_COLOR = Color.BLACK;
    private static final Image MINIMIZE_IMAGE = PhetCommonResources.getMinimizeButtonImage();
    private static final Image MAXIMIZE_IMAGE = PhetCommonResources.getMaximizeButtonImage();
    private boolean minimized;
    private EventListenerList listenerList;
    private PText textNode;
    private PImage buttonNode;
    private final IUserComponent minimizeButtonComponent;
    private final IUserComponent maximizeButtonComponent;

    public MinimizeMaximizeNode(IUserComponent iUserComponent, IUserComponent iUserComponent2, String string, int n) {
        this(iUserComponent, iUserComponent2, string, n, DEFAULT_FONT, DEFAULT_TEXT_COLOR, 5.0);
    }

    public MinimizeMaximizeNode(final IUserComponent iUserComponent, final IUserComponent iUserComponent2, String string, int n, Font font, Color color, double d) {
        this.minimizeButtonComponent = iUserComponent;
        this.maximizeButtonComponent = iUserComponent2;
        if (n != 2 && n != 4) {
            throw new IllegalArgumentException("invalid buttonPosition: " + n);
        }
        this.listenerList = new EventListenerList();
        this.textNode = new PText(string);
        this.textNode.setPaint(null);
        this.textNode.setFont(font);
        this.textNode.setTextPaint(color);
        this.addChild(this.textNode);
        this.buttonNode = new PImage(MAXIMIZE_IMAGE);
        this.addChild(this.buttonNode);
        final MinimizeMaximizeNode minimizeMaximizeNode = this;
        this.buttonNode.addInputEventListener(new PBasicInputEventHandler(){

            public void mouseReleased(PInputEvent pInputEvent) {
                MinimizeMaximizeNode.this.minimized = !MinimizeMaximizeNode.this.minimized;
                SimSharingManager.sendUserMessage(MinimizeMaximizeNode.this.isMinimized() ? iUserComponent : iUserComponent2, UserComponentTypes.button, UserActions.pressed);
                MinimizeMaximizeNode.this.updateView();
                MinimizeMaximizeNode.this.fireChangeEvent(new ChangeEvent(minimizeMaximizeNode));
            }
        });
        this.buttonNode.addInputEventListener(new CursorHandler());
        this.minimized = true;
        this.updateView();
        double d2 = Math.max(this.textNode.getFullBounds().getHeight(), this.buttonNode.getFullBounds().getHeight());
        if (n == 4) {
            this.textNode.setOffset(0.0, (d2 - this.textNode.getFullBounds().getHeight()) / 2.0);
            this.buttonNode.setOffset(this.textNode.getFullBounds().getWidth() + d, (d2 - this.buttonNode.getFullBounds().getHeight()) / 2.0);
        } else {
            this.buttonNode.setOffset(0.0, (d2 - this.buttonNode.getFullBounds().getHeight()) / 2.0);
            this.textNode.setOffset(this.buttonNode.getFullBounds().getWidth() + d, (d2 - this.textNode.getFullBounds().getHeight()) / 2.0);
        }
    }

    public void setMinimized(boolean bl) {
        if (bl != this.minimized) {
            this.minimized = bl;
            this.updateView();
            this.fireChangeEvent(new ChangeEvent(this));
        }
    }

    public void setMaximized(boolean bl) {
        this.setMinimized(!bl);
    }

    public boolean isMinimized() {
        return this.minimized;
    }

    public boolean isMaximized() {
        return !this.minimized;
    }

    private void updateView() {
        this.textNode.setVisible(this.minimized);
        this.buttonNode.setImage(this.minimized ? MAXIMIZE_IMAGE : MINIMIZE_IMAGE);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void fireChangeEvent(ChangeEvent changeEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }
}

