/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman.model;

import edu.colorado.phet.movingman.model.ManState;
import java.util.ArrayList;

public class MovingMan {
    private MotionStrategy motionStrategy = POSITION_DRIVEN;
    private ArrayList<Listener> listeners = new ArrayList();
    private double position;
    private double velocity;
    private double acceleration;
    public static MotionStrategy POSITION_DRIVEN = new MotionStrategy(){

        public void apply(MovingMan movingMan) {
            movingMan.setPositionDriven();
        }

        public String toString() {
            return "Position driven";
        }
    };
    public static MotionStrategy VELOCITY_DRIVEN = new MotionStrategy(){

        public void apply(MovingMan movingMan) {
            movingMan.setVelocityDriven();
        }

        public String toString() {
            return "Velocity driven";
        }
    };
    public static MotionStrategy ACCELERATION_DRIVEN = new MotionStrategy(){

        public void apply(MovingMan movingMan) {
            movingMan.setAccelerationDriven();
        }

        public String toString() {
            return "Acceleration driven";
        }
    };

    public MovingMan() {
        this.resetAll();
    }

    public void resetAll() {
        this.setPosition(0.0);
        this.setVelocity(0.0);
        this.setAcceleration(0.0);
        this.setPositionDriven();
    }

    public void setPosition(double d) {
        this.position = d;
        this.notifyListeners();
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public double getPosition() {
        return this.position;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public void setVelocity(double d) {
        this.velocity = d;
        this.notifyListeners();
    }

    private void notifyListeners() {
        for (Listener listener : this.listeners) {
            listener.changed();
        }
    }

    public void setAcceleration(double d) {
        this.acceleration = d;
        this.notifyListeners();
    }

    public double getAcceleration() {
        return this.acceleration;
    }

    public boolean isPositionDriven() {
        return this.motionStrategy == POSITION_DRIVEN;
    }

    public boolean isVelocityDriven() {
        return this.motionStrategy == VELOCITY_DRIVEN;
    }

    public boolean isAccelerationDriven() {
        return this.motionStrategy == ACCELERATION_DRIVEN;
    }

    public void setVelocityDriven() {
        this.motionStrategy = VELOCITY_DRIVEN;
        this.notifyListeners();
    }

    public void setPositionDriven() {
        this.motionStrategy = POSITION_DRIVEN;
        this.notifyListeners();
    }

    public void setAccelerationDriven() {
        this.motionStrategy = ACCELERATION_DRIVEN;
        this.notifyListeners();
    }

    public void setState(ManState manState) {
        this.setPosition(manState.getPosition());
        this.setVelocity(manState.getVelocity());
        this.setAcceleration(manState.getAcceleration());
        this.setMotionStrategy(manState.getMotionStrategy());
    }

    private void setMotionStrategy(MotionStrategy motionStrategy) {
        this.motionStrategy = motionStrategy;
        this.notifyListeners();
    }

    public MotionStrategy getMotionStrategy() {
        return this.motionStrategy;
    }

    public static interface Listener {
        public void changed();
    }

    public static interface MotionStrategy {
        public void apply(MovingMan var1);
    }
}

