/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman.view;

import edu.colorado.phet.common.motion.charts.Range;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.movingman.LinearTransform;
import edu.colorado.phet.movingman.MovingManColorScheme;
import edu.colorado.phet.movingman.MovingManResources;
import edu.colorado.phet.movingman.model.MovingMan;
import edu.colorado.phet.movingman.model.MovingManModel;
import edu.colorado.phet.movingman.model.MovingManState;
import edu.colorado.phet.movingman.view.MovingManNode;
import edu.colorado.phet.movingman.view.PlayAreaObjectNode;
import edu.colorado.phet.movingman.view.PlayAreaRulerNode;
import edu.colorado.phet.movingman.view.PlayAreaVector;
import edu.colorado.phet.movingman.view.TimeReadout;
import edu.colorado.phet.movingman.view.WallNode;
import edu.colorado.phet.recordandplayback.model.RecordAndPlaybackModel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.Color;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MovingManSimulationPanel
extends PhetPCanvas {
    private MovingManModel model;
    private double earthOffset;
    private final Range viewRange;
    private final PlayAreaRulerNode playAreaRulerNode;
    private BooleanProperty positiveToTheRight;
    private LinearTransform transform;
    protected TimeReadout timeReadout;

    public MovingManSimulationPanel(final MovingManModel movingManModel, final RecordAndPlaybackModel<MovingManState> recordAndPlaybackModel, int n, final BooleanProperty booleanProperty) {
        this.model = movingManModel;
        this.earthOffset = n;
        this.positiveToTheRight = booleanProperty;
        this.addScreenChild(new SkyNode());
        this.addScreenChild(new EarthNode());
        this.viewRange = new Range(0.0, 1000.0);
        this.playAreaRulerNode = new PlayAreaRulerNode(movingManModel.getModelRange(), this.viewRange);
        this.playAreaRulerNode.setOffset(0.0, n);
        this.addScreenChild(this.playAreaRulerNode);
        final SimpleObserver simpleObserver = new SimpleObserver(){

            public void update() {
                double d = (Boolean)booleanProperty.get() != false ? 100.0 : (double)(MovingManSimulationPanel.this.getWidth() - 100);
                double d2 = (Boolean)booleanProperty.get() != false ? (double)(MovingManSimulationPanel.this.getWidth() - 100) : 100.0;
                MovingManSimulationPanel.this.viewRange.setMin(d);
                MovingManSimulationPanel.this.viewRange.setMax(d2);
            }
        };
        final SimpleObserver simpleObserver2 = new SimpleObserver(){

            public void update() {
                double d = (Boolean)booleanProperty.get() != false ? 100.0 : (double)(MovingManSimulationPanel.this.getWidth() - 100);
                double d2 = (Boolean)booleanProperty.get() != false ? (double)(MovingManSimulationPanel.this.getWidth() - 100) : 100.0;
                MovingManSimulationPanel.this.viewRange.stepTowardsRange(d, d2, (double)MovingManSimulationPanel.this.getWidth() / 600.0 * 20.0);
            }
        };
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                simpleObserver.update();
            }
        });
        simpleObserver.update();
        Timer timer = new Timer(30, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                simpleObserver2.update();
            }
        });
        timer.start();
        this.transform = new LinearTransform(movingManModel.getRange(), this.viewRange);
        try {
            this.addScreenChild(new PlayAreaObjectNode(BufferedImageUtils.multiScaleToHeight(MovingManResources.loadBufferedImage("tree.gif"), 100), this.transform, -8.0, 0.0, booleanProperty));
            this.addScreenChild(new PlayAreaObjectNode(BufferedImageUtils.multiScaleToHeight(MovingManResources.loadBufferedImage("cottage.gif"), 100), this.transform, 8.0, 0.0, booleanProperty));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        final MovingManNode movingManNode = new MovingManNode(movingManModel.getMovingMan(), movingManModel, this.viewRange, booleanProperty);
        movingManNode.addInputEventListener(new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                recordAndPlaybackModel.startRecording();
            }
        });
        this.addScreenChild(movingManNode);
        try {
            BufferedImage bufferedImage = BufferedImageUtils.getScaledInstance(MovingManResources.loadBufferedImage("wall.jpg"), 60, 100, RenderingHints.VALUE_INTERPOLATION_BILINEAR, false);
            this.addScreenChild(new WallNode(bufferedImage, this.transform, -10.0, movingManModel.getWalls(), -movingManNode.getImageStanding().getWidth() / 2 - bufferedImage.getWidth() / 2, booleanProperty));
            this.addScreenChild(new WallNode(bufferedImage, this.transform, 10.0, movingManModel.getWalls(), movingManNode.getImageStanding().getWidth() / 2 + bufferedImage.getWidth() / 2, booleanProperty));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.timeReadout = new TimeReadout(movingManModel.getTimeProperty());
        this.transform.addObserver(new SimpleObserver(){

            public void update() {
                MovingManSimulationPanel.this.timeReadout.setOffset(Math.min(MovingManSimulationPanel.this.transform.evaluate(-6.0), MovingManSimulationPanel.this.transform.evaluate(6.0)), MovingManSimulationPanel.this.getTimeReadoutOffsetY());
            }
        });
        this.addScreenChild(this.timeReadout);
        int n2 = 28;
        final PlayAreaVector playAreaVector = new PlayAreaVector(MovingManColorScheme.semitransparent(MovingManColorScheme.VELOCITY_COLOR, 128), n2);
        this.addScreenChild(playAreaVector);
        final SimpleObserver simpleObserver3 = new SimpleObserver(){

            public void update() {
                double d = movingManNode.modelToView(movingManModel.getMovingMan().getPosition());
                double d2 = 0.2;
                double d3 = movingManNode.modelToView(movingManModel.getMovingMan().getPosition() + movingManModel.getMovingMan().getVelocity() * d2);
                playAreaVector.setArrow(d, 100.0, d3, 100.0);
            }
        };
        movingManModel.getMovingMan().addListener(new MovingMan.Listener(){

            public void changed() {
                simpleObserver3.update();
            }
        });
        this.viewRange.addObserver(simpleObserver3);
        movingManModel.getVelocityVectorVisible().addObserver(new SimpleObserver(){

            public void update() {
                MovingManSimulationPanel.this.updateVelocityVectorVisibility(movingManModel, playAreaVector);
            }
        });
        this.updateVelocityVectorVisibility(movingManModel, playAreaVector);
        final PlayAreaVector playAreaVector2 = new PlayAreaVector(MovingManColorScheme.semitransparent(MovingManColorScheme.ACCELERATION_COLOR, 128), n2);
        this.addScreenChild(playAreaVector2);
        final SimpleObserver simpleObserver4 = new SimpleObserver(){

            public void update() {
                double d = movingManNode.modelToView(movingManModel.getMovingMan().getPosition());
                double d2 = 0.8;
                double d3 = movingManNode.modelToView(movingManModel.getMovingMan().getPosition() + movingManModel.getMovingMan().getAcceleration() * d2);
                playAreaVector2.setArrow(d, 100.0, d3, 100.0);
            }
        };
        movingManModel.getMovingMan().addListener(new MovingMan.Listener(){

            public void changed() {
                simpleObserver4.update();
            }
        });
        this.viewRange.addObserver(simpleObserver4);
        movingManModel.getAccelerationVectorVisible().addObserver(new SimpleObserver(){

            public void update() {
                MovingManSimulationPanel.this.updateAccelerationVectorVisible(playAreaVector2, movingManModel);
            }
        });
        this.updateAccelerationVectorVisible(playAreaVector2, movingManModel);
        booleanProperty.addObserver(simpleObserver2);
    }

    public void resetAll() {
    }

    protected double getTimeReadoutOffsetY() {
        return 0.0;
    }

    public double getRulerHeight() {
        return this.playAreaRulerNode.getFullBounds().getHeight();
    }

    private void updateAccelerationVectorVisible(PlayAreaVector playAreaVector, MovingManModel movingManModel) {
        playAreaVector.setVisible((Boolean)movingManModel.getAccelerationVectorVisible().get());
    }

    private void updateVelocityVectorVisibility(MovingManModel movingManModel, PlayAreaVector playAreaVector) {
        playAreaVector.setVisible((Boolean)movingManModel.getVelocityVectorVisible().get());
    }

    protected PlayAreaRulerNode getPlayAreaRulerNode() {
        return this.playAreaRulerNode;
    }

    private class EarthNode
    extends PNode {
        private EarthNode() {
            PhetPPath phetPPath = new PhetPPath((Shape)new Rectangle2D.Double(-100.0, 100.0, 10000.0, 10000.0), (Paint)new Color(200, 240, 200));
            this.addChild(phetPPath);
        }
    }

    private class SkyNode
    extends PNode {
        private SkyNode() {
            PhetPPath phetPPath = new PhetPPath((Shape)new Rectangle2D.Double(-100.0, -500.0, 10000.0, 10000.0), (Paint)new Color(174, 217, 255));
            this.addChild(phetPPath);
        }
    }
}

