/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.math;

import java.awt.geom.Point2D;
import java.util.Random;

public class MathUtil {
    private static final Random random = new Random(System.currentTimeMillis());
    public static final double SQRT_2 = Math.sqrt(2.0);

    public static int getSign(int n) {
        return n >= 0 ? 1 : -1;
    }

    public static Point2D reflectPointAcrossLine(Point2D point2D, Point2D point2D2, double d) {
        double d2 = d % (Math.PI * 2);
        double d3 = Math.atan2(point2D.getY() - point2D2.getY(), point2D.getX() - point2D2.getX()) % (Math.PI * 2);
        double d4 = (2.0 * d2 - d3) % (Math.PI * 2);
        double d5 = point2D.distance(point2D2);
        return new Point2D.Double(point2D2.getX() + d5 * Math.cos(d4), point2D2.getY() + d5 * Math.sin(d4));
    }

    public static double clamp(double d, double d2, double d3) {
        if (Double.isNaN(d) || Double.isNaN(d2) || Double.isNaN(d3)) {
            return Double.NaN;
        }
        if (d2 < d) {
            return d;
        }
        if (d2 > d3) {
            return d3;
        }
        return d2;
    }

    public static long daysToMilliseconds(long l) {
        return l * 24L * 60L * 60L * 1000L;
    }
}

