/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sound;

import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.phetgraphics.view.help.HelpItem;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.sound.SingleSourceModule;
import edu.colorado.phet.sound.SoundConfig;
import edu.colorado.phet.sound.SoundResources;
import edu.colorado.phet.sound.model.SoundListener;
import edu.colorado.phet.sound.view.AudioControlPanel;
import edu.colorado.phet.sound.view.ListenerGraphic;
import edu.colorado.phet.sound.view.SoundControlPanel;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class SingleSourceListenModule
extends SingleSourceModule {
    private SoundListener speakerListener;
    private SoundListener headListener;
    private int headOffsetY = 20;
    private AudioControlPanel audioControlPanel;
    private ListenerGraphic listenerGraphic;

    public SingleSourceListenModule() {
        this(SoundResources.getString("ModuleTitle.SingleSourceListen"));
    }

    protected SingleSourceListenModule(String string) {
        super(string);
        this.init();
    }

    private void init() {
        this.speakerListener = new SoundListener(this.getSoundModel(), new Point2D.Double());
        this.speakerListener.setLocation(new Point2D.Double());
        this.setListener(this.speakerListener);
        this.headListener = new SoundListener(this.getSoundModel(), new Point2D.Double());
        this.headListener.addObserver(this.getPrimaryOscillator());
        this.headListener.addObserver(this.getOctaveOscillator());
        BufferedImage bufferedImage = null;
        try {
            int n = randomGenerator.nextInt(SoundConfig.HEAD_IMAGE_FILES.length);
            bufferedImage = ImageLoader.loadBufferedImage(SoundConfig.HEAD_IMAGE_FILES[n]);
            PhetImageGraphic phetImageGraphic = new PhetImageGraphic(this.getSimulationPanel(), bufferedImage);
            phetImageGraphic.setLocation(SoundConfig.s_headBaseX, SoundConfig.s_headBaseY);
            this.listenerGraphic = new ListenerGraphic(this, this.headListener, phetImageGraphic, SoundConfig.s_headBaseX, SoundConfig.s_headBaseY + this.headOffsetY, SoundConfig.s_headBaseX - 150, SoundConfig.s_headBaseY + this.headOffsetY, SoundConfig.s_headBaseX + 150, SoundConfig.s_headBaseY + this.headOffsetY);
            this.getApparatusPanel().addGraphic(this.listenerGraphic, 9.0);
            HelpItem helpItem = new HelpItem(this.getSimulationPanel(), SoundResources.getString("SingleSourceListenModule.help1"), SoundConfig.s_headBaseX, SoundConfig.s_headBaseY + this.headOffsetY - 20, 5, 1);
            helpItem.setForegroundColor(Color.white);
            this.addHelpItem(helpItem);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        SoundControlPanel soundControlPanel = (SoundControlPanel)this.getControlPanel();
        this.audioControlPanel = new AudioControlPanel(this, true);
        soundControlPanel.addPanel(this.audioControlPanel);
    }

    public boolean hasHelp() {
        return true;
    }

    protected ListenerGraphic getListenerGraphic() {
        return this.listenerGraphic;
    }

    protected SoundListener getSpeakerListener() {
        return this.speakerListener;
    }

    protected AudioControlPanel getAudioControlPanel() {
        return this.audioControlPanel;
    }

    public void setAudioSource(int n) {
        switch (n) {
            case 2: {
                this.setListener(this.headListener);
                break;
            }
            case 1: {
                this.setListener(this.speakerListener);
            }
        }
    }
}

