/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sound;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetgraphics.application.PhetGraphicsModule;
import edu.colorado.phet.sound.model.SineWaveFunction;
import edu.colorado.phet.sound.model.SoundListener;
import edu.colorado.phet.sound.model.SoundModel;
import edu.colorado.phet.sound.model.Wavefront;
import edu.colorado.phet.sound.view.RgbReporter;
import edu.colorado.phet.sound.view.WavefrontOscillator;
import java.awt.geom.Point2D;
import java.util.Random;

public abstract class SoundModule
extends PhetGraphicsModule
implements RgbReporter {
    private static WavefrontOscillator primaryOscillator = new WavefrontOscillator();
    private static WavefrontOscillator octaveOscillator = new WavefrontOscillator();
    private SoundListener speakerListener;
    protected static final Random randomGenerator = new Random();
    private boolean audioEnabled = false;
    private Wavefront primaryWavefront;
    private Wavefront octaveWavefront;
    private SoundListener currentListener;
    private Boolean saveAudioEnabledState;
    private final IClock clock = this.getClock();
    private final SoundModel model = new SoundModel();

    public SoundModule(String string) {
        super(string, new ConstantDtClock(50, 5.0));
        this.initModel();
        this.setModel(this.model);
        this.speakerListener = new SoundListener(this.model, new Point2D.Double());
        this.setListener(this.speakerListener);
        this.clock.addClockListener(new ClockAdapter(){

            public void clockStarted(ClockEvent clockEvent) {
                this.stateChanged(clockEvent.getClock().isPaused());
            }

            public void clockPaused(ClockEvent clockEvent) {
                this.stateChanged(clockEvent.getClock().isPaused());
            }

            private void stateChanged(boolean bl) {
                if (SoundModule.this.isActive()) {
                    if (bl) {
                        SoundModule.this.saveAudioEnabledState = new Boolean(SoundModule.this.audioEnabled);
                        primaryOscillator.setEnabled(false);
                        octaveOscillator.setEnabled(false);
                    } else {
                        SoundModule.this.setAudioEnabled(SoundModule.this.audioEnabled);
                        if (SoundModule.this.saveAudioEnabledState != null) {
                            SoundModule.this.setAudioEnabled(SoundModule.this.saveAudioEnabledState);
                        }
                        SoundModule.this.saveAudioEnabledState = null;
                    }
                } else if (SoundModule.this.saveAudioEnabledState != null) {
                    SoundModule.this.audioEnabled = SoundModule.this.saveAudioEnabledState;
                }
            }
        });
    }

    public SoundModel getSoundModel() {
        return this.model;
    }

    public void activate() {
        super.activate();
        if (!this.clock.isPaused()) {
            this.setAudioEnabled(this.audioEnabled);
        }
        if (this.currentListener != null) {
            this.setListener(this.currentListener);
        }
    }

    public void deactivate() {
        super.deactivate();
        this.setAudioEnabled(false);
    }

    public void setAudioEnabled(boolean bl) {
        if (this.clock.isPaused()) {
            this.saveAudioEnabledState = new Boolean(bl);
        } else {
            this.audioEnabled = bl;
            primaryOscillator.setEnabled(bl);
            if (this.audioEnabled) {
                primaryOscillator.run();
            }
            octaveOscillator.setEnabled(bl && this.getSoundModel().isOctaveEnabled());
        }
    }

    private void initModel() {
        this.primaryWavefront = new Wavefront();
        this.primaryWavefront.setWaveFunction(new SineWaveFunction(this.primaryWavefront));
        this.primaryWavefront.setEnabled(true);
        this.getSoundModel().addWaveFront(this.primaryWavefront);
        this.getSoundModel().setPrimaryWavefront(this.primaryWavefront);
        this.octaveWavefront = new Wavefront();
        this.octaveWavefront.setWaveFunction(new SineWaveFunction(this.octaveWavefront));
        this.octaveWavefront.setMaxAmplitude(0.0);
        this.octaveWavefront.setEnabled(false);
        this.getSoundModel().addWaveFront(this.octaveWavefront);
        this.getSoundModel().setOctaveWavefront(this.octaveWavefront);
        this.getSoundModel().setFrequency(500.0);
    }

    public void setAudioSource(int n) {
    }

    public WavefrontOscillator getPrimaryOscillator() {
        return primaryOscillator;
    }

    public WavefrontOscillator getOctaveOscillator() {
        return octaveOscillator;
    }

    public void setListener(SoundListener soundListener) {
        this.currentListener = soundListener;
        primaryOscillator.setListener(soundListener);
        octaveOscillator.setListener(soundListener);
    }

    public int rgbAt(int n, int n2) {
        return 128;
    }

    static {
        octaveOscillator.setHarmonicFactor(2.0);
    }
}

