/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sound.model;

import edu.colorado.phet.common.phetcommon.model.BaseModel;
import edu.colorado.phet.sound.model.WaveMedium;
import edu.colorado.phet.sound.model.Wavefront;

public class SoundModel
extends BaseModel {
    private WaveMedium waveMedium = new WaveMedium();
    private Wavefront primaryWavefront;
    private Wavefront octaveWavefront;
    private boolean octaveEnabled = false;

    public SoundModel() {
        this.setWaveMedium(this.waveMedium);
    }

    public WaveMedium getWaveMedium() {
        return this.waveMedium;
    }

    public void setWaveMedium(WaveMedium waveMedium) {
        if (this.waveMedium != null) {
            this.removeModelElement(this.waveMedium);
        }
        this.waveMedium = waveMedium;
        this.addModelElement(waveMedium);
    }

    public void addWaveFront(Wavefront wavefront) {
        this.waveMedium.addWavefront(wavefront);
        this.setPropagationSpeed(3);
    }

    public void setPropagationSpeed(int n) {
        for (Wavefront wavefront : this.waveMedium.getWavefronts()) {
            wavefront.setPropagationSpeed(n);
        }
    }

    public void setFrequency(double d) {
        this.primaryWavefront.setFrequency(d / 4000.0);
        this.octaveWavefront.setFrequency(2.0 * d / 4000.0);
    }

    public double getAmplitude() {
        return this.primaryWavefront.getMaxAmplitude();
    }

    public void setAmplitude(double d) {
        this.primaryWavefront.setMaxAmplitude(d);
    }

    public void setOctaveWavefront(Wavefront wavefront) {
        this.octaveWavefront = wavefront;
    }

    public Wavefront getPrimaryWavefront() {
        return this.primaryWavefront;
    }

    public Wavefront getOctaveWavefront() {
        return this.octaveWavefront;
    }

    public void setPrimaryWavefront(Wavefront wavefront) {
        this.primaryWavefront = wavefront;
    }

    public boolean isOctaveEnabled() {
        return this.octaveEnabled;
    }
}

