/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sound.view;

import edu.colorado.phet.common.phetcommon.view.ControlPanel;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.sound.SoundModule;
import edu.colorado.phet.sound.SoundResources;
import edu.colorado.phet.sound.model.SoundModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SoundControlPanel
extends ControlPanel {
    private MyControlPanel soundControlPanel;
    private int rowIdx = 0;
    private AmplitudeControlPanel amplitudeControlPanel;

    public SoundControlPanel(SoundModule soundModule) {
        super(soundModule);
        this.soundControlPanel = new MyControlPanel(soundModule);
        this.addControl(this.soundControlPanel);
    }

    public void addPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, this.rowIdx++, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0);
        this.soundControlPanel.add((Component)jPanel, gridBagConstraints);
    }

    public void setAmplitude(double d) {
        this.amplitudeControlPanel.setAmplitude(d);
    }

    private static class AmplitudeControlPanel
    extends JPanel {
        private JSlider amplitudeSlider;
        private int sliderMax = 10;
        private int sliderMin = 0;
        private int sliderDefault = 5;
        private SoundModel model;

        AmplitudeControlPanel(SoundModel soundModel) {
            this.model = soundModel;
            this.setLayout(new GridLayout(1, 2));
            this.setPreferredSize(new Dimension(125, 60));
            this.amplitudeSlider = new JSlider(0, this.sliderMin, this.sliderMax, this.sliderDefault);
            this.amplitudeSlider.setPreferredSize(new Dimension(25, 100));
            this.amplitudeSlider.setPaintTicks(true);
            this.amplitudeSlider.setMajorTickSpacing(5);
            this.amplitudeSlider.setMinorTickSpacing(1);
            this.amplitudeSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    AmplitudeControlPanel.this.setModelAmplitude(AmplitudeControlPanel.this.amplitudeSlider.getValue());
                }
            });
            this.setModelAmplitude(this.amplitudeSlider.getValue());
            this.add(this.amplitudeSlider);
            TitledBorder titledBorder = new TitledBorder(SoundResources.getString("SoundControlPanel.Amplitude"));
            this.setBorder(titledBorder);
        }

        private void setModelAmplitude(int n) {
            double d = (double)n * 1.0 / (double)(this.sliderMax - this.sliderMin);
            this.model.setAmplitude(d);
        }

        public void setAmplitude(double d) {
            int n = (int)((double)(this.sliderMax - this.sliderMin) * d + (double)this.sliderMin);
            this.amplitudeSlider.setValue(n);
            this.setModelAmplitude(n);
        }
    }

    private static class FrequencyControlPanel
    extends VerticalLayoutPanel {
        private JLabel frequencyLabel;
        private JSlider frequencySlider;
        private String Hertz = SoundResources.getString("SoundControlPanel.Hertz");

        FrequencyControlPanel(final SoundModel soundModel) {
            this.setPreferredSize(new Dimension(125, 80));
            this.frequencyLabel = new JLabel();
            this.frequencyLabel.setFont(new PhetFont(1, 12));
            this.frequencyLabel.setText(Integer.toString(500) + " " + this.Hertz);
            this.frequencySlider = new JSlider(0, 0, 1000, 500);
            this.frequencySlider.setPreferredSize(new Dimension(20, 60));
            this.frequencySlider.setPaintTicks(true);
            this.frequencySlider.setMajorTickSpacing(100);
            this.frequencySlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    FrequencyControlPanel.this.updateFrequency(soundModel, FrequencyControlPanel.this.frequencySlider.getValue());
                    FrequencyControlPanel.this.frequencyLabel.setText(Integer.toString(FrequencyControlPanel.this.frequencySlider.getValue()) + " " + FrequencyControlPanel.this.Hertz);
                }
            });
            this.updateFrequency(soundModel, this.frequencySlider.getValue());
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(new EmptyBorder(0, 0, 0, 10));
            jPanel.add((Component)this.frequencyLabel, "East");
            this.add(jPanel);
            this.add(this.frequencySlider);
            TitledBorder titledBorder = new TitledBorder(SoundResources.getString("SoundControlPanel.BorderTitle"));
            this.setBorder(titledBorder);
        }

        private void updateFrequency(SoundModel soundModel, int n) {
            this.frequencyLabel.setText(Integer.toString(n) + " " + this.Hertz);
            soundModel.setFrequency(n);
        }
    }

    private class MyControlPanel
    extends JPanel {
        MyControlPanel(SoundModule soundModule) {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints(0, SoundControlPanel.this.rowIdx++, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0);
            this.add((Component)new FrequencyControlPanel(soundModule.getSoundModel()), gridBagConstraints);
            gridBagConstraints.gridy = SoundControlPanel.this.rowIdx++;
            SoundControlPanel.this.amplitudeControlPanel = new AmplitudeControlPanel(soundModule.getSoundModel());
            this.add((Component)SoundControlPanel.this.amplitudeControlPanel, gridBagConstraints);
        }
    }
}

