/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sound.view;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.sound.model.SoundListener;
import java.awt.geom.Point2D;
import javasound.SrrOscillatorPlayer;

public class WavefrontOscillator
extends SrrOscillatorPlayer
implements SimpleObserver {
    private boolean isEnabled = false;
    private double amplitude;
    private SoundListener listener;
    private double harmonicFactor = 1.0;
    private Point2D.Double refPt = new Point2D.Double();
    private boolean interferenceOverideEnabled = false;

    public void setHarmonicFactor(double d) {
        this.harmonicFactor = d;
    }

    public void setAmplitude(double d) {
        if (d < 0.0) {
            throw new RuntimeException("amplitude < 0");
        }
        super.setAmplitude(this.isEnabled ? (float)(d /= 1.0) : 0.0f);
        this.amplitude = d;
    }

    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
        if (this.isEnabled) {
            super.setAmplitude((float)this.amplitude);
        } else {
            super.setAmplitude(0.0f);
        }
        this.update();
    }

    public void update() {
        if (this.listener != null) {
            this.refPt = this.listener.getLocation();
        }
        double d = this.listener.getFrequencyHeard() * this.harmonicFactor;
        double d2 = this.listener.getAmplitudeHeard();
        if (d2 < -1.0) {
            throw new RuntimeException("amplitude < -1");
        }
        double d3 = d = d == 0.0 ? (double)0.1f : d * 4000.0;
        if (d != (double)this.getFrequency()) {
            this.setFrequency((float)d);
        }
        this.setAmplitude(d2);
    }

    public void setListener(SoundListener soundListener) {
        if (this.listener != null) {
            this.listener.removeObserver(this);
        }
        this.listener = soundListener;
        soundListener.addObserver(this);
        this.update();
    }

    public void setInterferenceOverideEnabled(boolean bl) {
        this.interferenceOverideEnabled = bl;
        this.update();
    }

    public boolean getInterferenceOverideEnabled() {
        return this.interferenceOverideEnabled;
    }
}

