/*
 * Decompiled with CFR 0.152.
 */
package jass.render;

public final class FormatUtils {
    public static boolean bigEndian = false;

    public static final void shortToFloat(float[] fArray, short[] sArray, int n) {
        for (int i = 0; i < n; ++i) {
            fArray[i] = (float)((double)sArray[i] / 32768.0);
        }
    }

    public static final void floatToByte(byte[] byArray, float[] fArray) {
        int n = fArray.length;
        int n2 = 0;
        if (bigEndian) {
            for (int i = 0; i < n; ++i) {
                short s = (short)(32767.0 * (double)fArray[i]);
                byArray[n2] = (byte)(s >> 8);
                byArray[++n2] = (byte)(s & 0xFF);
                ++n2;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                short s = (short)(32767.0 * (double)fArray[i]);
                byArray[n2] = (byte)(s & 0xFF);
                byArray[++n2] = (byte)(s >> 8);
                ++n2;
            }
        }
    }

    public static final void byteToFloat(float[] fArray, byte[] byArray, int n) {
        int n2 = 0;
        if (bigEndian) {
            for (int i = 0; i < n; ++i) {
                short s = byArray[n2];
                s = (short)(s << 8);
                s = (short)(s + byArray[n2 + 1]);
                n2 += 2;
                fArray[i] = (float)s / 32768.0f;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                short s = byArray[n2 + 1];
                s = (short)(s << 8);
                s = (short)(s + byArray[n2]);
                n2 += 2;
                fArray[i] = (float)s / 32768.0f;
            }
        }
    }
}

