/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sound;

import edu.colorado.phet.sound.SoundConfig;
import edu.colorado.phet.sound.SoundModule;
import edu.colorado.phet.sound.model.WaveMedium;
import edu.colorado.phet.sound.model.Wavefront;
import edu.colorado.phet.sound.view.SingleSourceApparatusPanel;
import edu.colorado.phet.sound.view.SoundControlPanel;
import edu.colorado.phet.sound.view.WaveMediumGraphic;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public abstract class SingleSourceModule
extends SoundModule {
    private final SingleSourceApparatusPanel apparatusPanel = new SingleSourceApparatusPanel(this.getSoundModel(), this.getClock());
    private final WaveMedium waveMedium;

    protected SingleSourceModule(String string) {
        super(string);
        this.setApparatusPanel(this.apparatusPanel);
        this.waveMedium = this.getSoundModel().getWaveMedium();
        WaveMediumGraphic waveMediumGraphic = new WaveMediumGraphic(this.waveMedium, this.apparatusPanel, this);
        this.apparatusPanel.addGraphic(waveMediumGraphic, 7.0);
        Point2D.Double double_ = new Point2D.Double(SoundConfig.s_wavefrontBaseX, SoundConfig.s_wavefrontBaseY);
        waveMediumGraphic.initLayout(double_, SoundConfig.s_wavefrontHeight, SoundConfig.s_wavefrontRadius);
        this.setControlPanel(new SoundControlPanel(this));
    }

    protected void resetWaveMediumGraphic() {
        ArrayList arrayList = this.waveMedium.getWavefronts();
        for (int i = 0; i < arrayList.size(); ++i) {
            Wavefront wavefront = (Wavefront)arrayList.get(i);
            wavefront.clear();
        }
    }
}

