/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sound;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel;
import edu.colorado.phet.sound.SingleSourceModule;
import edu.colorado.phet.sound.SoundConfig;
import edu.colorado.phet.sound.SoundResources;
import edu.colorado.phet.sound.model.SoundModel;
import edu.colorado.phet.sound.view.BufferedWaveMediumGraphic;
import edu.colorado.phet.sound.view.ReflectingWallGraphic;
import edu.colorado.phet.sound.view.SoundControlPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WallInterferenceModule
extends SingleSourceModule {
    private static double s_wallOffsetX = 170.0;
    private static double s_wallOffsetY = 300.0;
    private static double s_wallThickness = 650.0;
    private static double s_wallHeight = 6.0;
    private static double s_initialWallAngle = 60.0;
    private SoundModel soundModel;
    private ReflectingWallGraphic wallGraphic;
    private double wallAngle = s_initialWallAngle;
    private BufferedWaveMediumGraphic interferringWavefrontGraphic;
    private Point2D.Double p;
    private Point2D.Double pp;
    private final IClock clock;

    public WallInterferenceModule() {
        super(SoundResources.getString("ModuleTitle.WallInterference"));
        this.soundModel = this.getSoundModel();
        this.clock = this.getClock();
        ApparatusPanel apparatusPanel = (ApparatusPanel)this.getSimulationPanel();
        this.wallGraphic = new ReflectingWallGraphic(this.getSimulationPanel(), Color.blue, (double)SoundConfig.s_wavefrontBaseX + s_wallOffsetX, (double)SoundConfig.s_wavefrontBaseY + s_wallOffsetY, s_wallThickness, s_wallHeight, s_initialWallAngle);
        apparatusPanel.addGraphic(this.wallGraphic, 8.0);
        this.interferringWavefrontGraphic = new BufferedWaveMediumGraphic(this.soundModel.getWaveMedium(), apparatusPanel);
        apparatusPanel.addGraphic(this.interferringWavefrontGraphic, 7.0);
        this.positionInterferingWavefront();
        WallTiltControlPanel wallTiltControlPanel = new WallTiltControlPanel();
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        jPanel.add(wallTiltControlPanel);
        jPanel.add(new WallTranslateControlPanel());
        ((SoundControlPanel)this.getControlPanel()).addPanel(jPanel);
        ((SoundControlPanel)this.getControlPanel()).setAmplitude(1.0);
        ((SoundControlPanel)this.getControlPanel()).addPanel(new PulsePanel());
        apparatusPanel.invalidate();
        apparatusPanel.repaint();
    }

    private void positionInterferingWavefront() {
        this.p = new Point2D.Double(SoundConfig.s_wavefrontBaseX, SoundConfig.s_wavefrontBaseY);
        Point2D point2D = MathUtil.reflectPointAcrossLine(this.p, new Point2D.Double(this.wallGraphic.getMidPoint().getX(), this.wallGraphic.getMidPoint().getY()), Math.toRadians(-this.wallAngle));
        this.pp = (Point2D.Double)point2D;
        this.interferringWavefrontGraphic.clear();
        this.interferringWavefrontGraphic.initLayout(new Point2D.Double(this.pp.getX(), this.pp.getY()), SoundConfig.s_wavefrontHeight, SoundConfig.s_wavefrontRadius, this.wallAngle * 2.0);
        this.interferringWavefrontGraphic.setOpacity(0.5f);
    }

    public void setWallAngle(float f) {
        this.wallAngle = f;
        this.wallGraphic.setAngle(this.wallAngle);
        this.positionInterferingWavefront();
    }

    public void setWallLocation(float f) {
        this.wallGraphic.setLocation((float)SoundConfig.s_wavefrontBaseX + f);
        this.positionInterferingWavefront();
    }

    private class PulsePanel
    extends JPanel {
        private JButton pulseBtn;
        private Double savedAmplitude;

        public PulsePanel() {
            super(new GridBagLayout());
            this.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(), SoundResources.getString("WallInterferenceMode.modeCtrlTitle")));
            ButtonGroup buttonGroup = new ButtonGroup();
            final JRadioButton jRadioButton = new JRadioButton(SoundResources.getString("WallInterferenceMode.continuous"));
            final JRadioButton jRadioButton2 = new JRadioButton(SoundResources.getString("WallInterferenceMode.pulse"));
            buttonGroup.add(jRadioButton);
            buttonGroup.add(jRadioButton2);
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setBorder(BorderFactory.createTitledBorder(new EtchedBorder(), SoundResources.getString("WallInterferenceMode.modeTitle")));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 20, 0, 20);
            jPanel.add((Component)jRadioButton, gridBagConstraints);
            ++gridBagConstraints.gridx;
            jPanel.add((Component)jRadioButton2, gridBagConstraints);
            this.pulseBtn = new JButton(SoundResources.getString("WallInterferenceMode.fire"));
            this.pulseBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PulsePanel.this.producePulse();
                }
            });
            ++gridBagConstraints.gridy;
            jPanel.add((Component)this.pulseBtn, gridBagConstraints);
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 2;
            this.add((Component)jPanel, gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 10;
            this.add((Component)this.pulseBtn, gridBagConstraints);
            jRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (jRadioButton.isSelected()) {
                        PulsePanel.this.setPulseMode(false);
                    }
                }
            });
            jRadioButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (jRadioButton2.isSelected()) {
                        PulsePanel.this.setPulseMode(true);
                    }
                }
            });
            this.setPulseMode(false);
            jRadioButton.setSelected(true);
        }

        private void setPulseMode(boolean bl) {
            this.pulseBtn.setEnabled(bl);
            if (bl) {
                this.savedAmplitude = new Double(WallInterferenceModule.this.soundModel.getPrimaryWavefront().getMaxAmplitude());
                WallInterferenceModule.this.soundModel.getPrimaryWavefront().clear();
                WallInterferenceModule.this.soundModel.getPrimaryWavefront().setMaxAmplitude(0.0);
            } else if (this.savedAmplitude != null) {
                WallInterferenceModule.this.soundModel.getPrimaryWavefront().setMaxAmplitude(this.savedAmplitude);
            }
        }

        private void producePulse() {
            Runnable runnable = new Runnable(){

                public void run() {
                    WallInterferenceModule.this.soundModel.getPrimaryWavefront().setMaxAmplitude(PulsePanel.this.savedAmplitude);
                    double d = WallInterferenceModule.this.clock.getSimulationTime();
                    double d2 = 6.0 / WallInterferenceModule.this.soundModel.getPrimaryWavefront().getFrequency();
                    WallInterferenceModule.this.soundModel.getPrimaryWavefront().getAmplitude();
                    while (WallInterferenceModule.this.clock.getSimulationTime() - d < d2) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                    }
                    WallInterferenceModule.this.soundModel.getPrimaryWavefront().setMaxAmplitude(0.0);
                }
            };
            Thread thread = new Thread(runnable);
            thread.start();
        }
    }

    public class WallTiltControlPanel
    extends JPanel {
        WallTiltControlPanel() {
            this.setLayout(new GridLayout(1, 1));
            this.setPreferredSize(new Dimension(125, 100));
            final JSlider jSlider = new JSlider(1, 10, 90, (int)s_initialWallAngle);
            jSlider.setPreferredSize(new Dimension(25, 100));
            jSlider.setPaintTicks(true);
            jSlider.setMajorTickSpacing(20);
            jSlider.setMinorTickSpacing(10);
            jSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    WallInterferenceModule.this.setWallAngle(jSlider.getValue());
                }
            });
            this.add(jSlider);
            TitledBorder titledBorder = new TitledBorder(SoundResources.getString("WallInterferenceModule.Angle"));
            this.setBorder(titledBorder);
        }
    }

    public class WallTranslateControlPanel
    extends JPanel {
        WallTranslateControlPanel() {
            this.setLayout(new GridLayout(1, 1));
            this.setPreferredSize(new Dimension(125, 70));
            final JSlider jSlider = new JSlider(0, 0, 400, (int)s_wallOffsetX);
            jSlider.setPreferredSize(new Dimension(25, 100));
            jSlider.setPaintTicks(true);
            jSlider.setMajorTickSpacing(50);
            jSlider.setMinorTickSpacing(25);
            jSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    WallInterferenceModule.this.setWallLocation(jSlider.getValue());
                }
            });
            this.add(jSlider);
            TitledBorder titledBorder = new TitledBorder(SoundResources.getString("WallInterferenceModule.Position"));
            this.setBorder(titledBorder);
        }
    }
}

