/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sound.view;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.sound.SoundConfig;
import edu.colorado.phet.sound.model.WaveMedium;
import edu.colorado.phet.sound.model.Wavefront;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

public class BufferedWaveMediumGraphic
extends PhetImageGraphic
implements SimpleObserver {
    static Color[] s_lineColor = new Color[256];
    protected static Stroke s_defaultStroke;
    private Point2D.Double origin;
    private double height = SoundConfig.s_wavefrontHeight;
    private double stroke = 1.0;
    private double radius = SoundConfig.s_wavefrontRadius;
    private boolean isPlanar;
    private double[] amplitudes = new double[Wavefront.s_length];
    private BufferedImage buffImg;
    private Graphics2D g2DBuffImg;
    private AffineTransform nopAT = new AffineTransform();
    private float opacity = 1.0f;
    private double rotationAngle = 0.0;
    private AffineTransform lineRotationXform;
    private WaveMedium waveMedium;
    private Point2D.Double[] arcCenters = new Point2D.Double[Wavefront.s_length];

    private static BufferedImage createBufferedImage() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        return graphicsConfiguration.createCompatibleImage(800, 800);
    }

    public BufferedWaveMediumGraphic(WaveMedium waveMedium, Component component) {
        super(component, BufferedWaveMediumGraphic.createBufferedImage());
        this.waveMedium = waveMedium;
        waveMedium.addObserver(this);
        this.buffImg = super.getImage();
        this.g2DBuffImg = this.buffImg.createGraphics();
        this.g2DBuffImg.setColor(SoundConfig.MIDDLE_GRAY);
        this.g2DBuffImg.fill(new Rectangle(this.buffImg.getMinX(), this.buffImg.getMinY(), this.buffImg.getWidth(), this.buffImg.getHeight()));
        this.g2DBuffImg.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        this.g2DBuffImg.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        this.g2DBuffImg.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        this.g2DBuffImg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.g2DBuffImg.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        this.g2DBuffImg.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        this.g2DBuffImg.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
    }

    public void initLayout(Point2D.Double double_, double d, double d2) {
        this.initLayout(double_, d, d2, 0.0);
    }

    public void initLayout(Point2D.Double double_, double d, double d2, double d3) {
        this.origin = double_;
        this.height = d;
        this.radius = d2;
        this.setRotationAngle(d3);
        for (int i = 0; i < this.arcCenters.length; ++i) {
            this.arcCenters[i] = double_;
        }
    }

    public void clear() {
        this.g2DBuffImg.setColor(SoundConfig.MIDDLE_GRAY);
        this.g2DBuffImg.fill(new Rectangle(this.buffImg.getMinX(), this.buffImg.getMinY(), this.buffImg.getWidth(), this.buffImg.getHeight()));
    }

    private void setRotationAngle(double d) {
        this.rotationAngle = d;
        this.lineRotationXform = AffineTransform.getRotateInstance(-Math.toRadians(this.rotationAngle), this.origin.getX(), this.origin.getY());
    }

    public void setOpacity(float f) {
        this.opacity = f;
    }

    public void paint(Graphics2D graphics2D) {
        int n;
        this.clear();
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.opacity));
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(s_defaultStroke);
        Color color = graphics2D.getColor();
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        Line2D.Float float_3 = new Line2D.Float();
        float f = (float)(Math.asin(this.height / (2.0 * this.radius)) * 57.29577951308232);
        Arc2D.Float float_4 = new Arc2D.Float();
        double d = this.height - 20.0;
        double d2 = this.radius - 20.0;
        float f2 = (float)Math.asin(d / (2.0 * d2));
        for (n = this.arcCenters.length - 1; n > 3; --n) {
            this.arcCenters[n] = this.arcCenters[n - 3];
        }
        for (n = 0; n < 50; ++n) {
            this.arcCenters[n] = this.origin;
        }
        for (n = 0; n < this.waveMedium.getMaxX(); ++n) {
            double d3 = this.amplitudes[n];
            int n2 = (int)(-d3 * (double)(s_lineColor.length / 2) + (double)(s_lineColor.length / 2));
            graphics2D.setColor(s_lineColor[n2]);
            Point2D.Double double_ = this.arcCenters[n];
            if (this.isPlanar) {
                ((Point2D)float_).setLocation(this.origin.getX() + 15.0 + (double)n * this.stroke, this.origin.getY() - 22.0);
                ((Point2D)float_2).setLocation(this.origin.getX() + 15.0 + (double)n * this.stroke, this.origin.getY() + this.height + 22.0);
                float_3.setLine(float_, float_2);
                graphics2D.draw(float_3);
                continue;
            }
            if (double_ == null) continue;
            float_4.setArc(double_.getX() - d2 - (double)n * this.stroke, double_.getY() - d2 - (double)n * this.stroke, d2 * 2.0 + (double)n * this.stroke * 2.0, d2 * 2.0 + (double)n * this.stroke * 2.0, (double)(-f) + this.rotationAngle, f * 2.0f, 0);
            this.g2DBuffImg.setColor(s_lineColor[n2]);
            this.g2DBuffImg.draw(float_4);
        }
        this.g2DBuffImg.setColor(SoundConfig.MIDDLE_GRAY);
        this.g2DBuffImg.fillRect(0, 0, 190, this.buffImg.getHeight());
        graphics2D.drawImage(this.buffImg, this.nopAT, null);
        graphics2D.setStroke(stroke);
        graphics2D.setColor(color);
        graphics2D.setComposite(composite);
    }

    public Point2D getOrigin() {
        return this.origin;
    }

    public void setOrigin(Point2D.Double double_) {
        this.origin = new Point2D.Double(double_.x, double_.y);
    }

    public void update() {
        for (int i = 0; i < this.amplitudes.length; ++i) {
            this.amplitudes[i] = this.waveMedium.getAmplitudeAt(i);
        }
        this.repaint();
    }

    static {
        for (int i = 0; i < s_lineColor.length; ++i) {
            BufferedWaveMediumGraphic.s_lineColor[i] = new Color(i, i, i);
        }
        s_defaultStroke = new BasicStroke(1.0f);
    }
}

