/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sound.view;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.common.phetgraphics.view.graphics.mousecontrols.translation.TranslationEvent;
import edu.colorado.phet.common.phetgraphics.view.graphics.mousecontrols.translation.TranslationListener;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.sound.SoundConfig;
import edu.colorado.phet.sound.view.BufferedWaveMediumGraphic;
import edu.colorado.phet.sound.view.SpeakerGraphic;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.event.ChangeEvent;

public class InteractiveSpeakerGraphic
extends CompositePhetGraphic {
    private SpeakerGraphic speakerGraphic;
    private BufferedWaveMediumGraphic waveMediumGraphic;
    private ArrayList mouseReleaseListeners = new ArrayList();
    private EventChannel changeEventChannel = new EventChannel(InteractiveSpeakerChangeListener.class);
    private InteractiveSpeakerChangeListener changeListenerProxy = (InteractiveSpeakerChangeListener)this.changeEventChannel.getListenerProxy();

    public InteractiveSpeakerGraphic(SpeakerGraphic speakerGraphic, BufferedWaveMediumGraphic bufferedWaveMediumGraphic) {
        this.speakerGraphic = speakerGraphic;
        this.addGraphic(speakerGraphic);
        this.waveMediumGraphic = bufferedWaveMediumGraphic;
        this.setCursorHand();
        this.addTranslationListener(new SpeakerTranslator());
    }

    public Point2D.Double getAudioSourceLocation() {
        return new Point2D.Double(this.waveMediumGraphic.getOrigin().getX(), this.waveMediumGraphic.getOrigin().getY());
    }

    public void addChangeListener(InteractiveSpeakerChangeListener interactiveSpeakerChangeListener) {
        this.changeEventChannel.addListener(interactiveSpeakerChangeListener);
    }

    public static interface InteractiveSpeakerChangeListener
    extends EventListener {
        public void stateChanged(ChangeEvent var1);
    }

    private class SpeakerTranslator
    implements TranslationListener {
        private SpeakerTranslator() {
        }

        public void translationOccurred(TranslationEvent translationEvent) {
            Point point = InteractiveSpeakerGraphic.this.speakerGraphic.getLocation();
            InteractiveSpeakerGraphic.this.speakerGraphic.setLocation((int)((Point2D)point).getX(), (int)(((Point2D)point).getY() + (double)(2 * MathUtil.getSign(translationEvent.getDy()))));
            InteractiveSpeakerGraphic.this.waveMediumGraphic.setOrigin(new Point2D.Double(SoundConfig.s_wavefrontBaseX, ((InteractiveSpeakerGraphic)InteractiveSpeakerGraphic.this).speakerGraphic.getLocation().y));
            InteractiveSpeakerGraphic.this.changeListenerProxy.stateChanged(new ChangeEvent(InteractiveSpeakerGraphic.this));
        }
    }
}

