/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sound.view;

import edu.colorado.phet.common.phetgraphics.view.graphics.mousecontrols.translation.TranslationEvent;
import edu.colorado.phet.common.phetgraphics.view.graphics.mousecontrols.translation.TranslationListener;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.CompositePhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public class VerticalGuideline
extends CompositePhetGraphic {
    private int xLocation;

    public VerticalGuideline(final Component component, Color color, int n) {
        super(null);
        final VerticalLine verticalLine = new VerticalLine(component, color, n);
        this.addGraphic(verticalLine);
        this.setCursor(Cursor.getPredefinedCursor(10));
        this.xLocation = n;
        this.addTranslationListener(new TranslationListener(){

            public void translationOccurred(TranslationEvent translationEvent) {
                VerticalGuideline.this.xLocation += translationEvent.getDx();
                verticalLine.setLocation(VerticalGuideline.this.xLocation);
                component.repaint();
            }
        });
    }

    private static class VerticalLine
    extends PhetShapeGraphic {
        private Rectangle2D.Double line = new Rectangle2D.Double();
        private Color color;

        public VerticalLine(Component component, Color color, int n) {
            super(component, null, color);
            this.setShape(this.line);
            this.setLocation(n);
            this.color = color;
        }

        public void paint(Graphics2D graphics2D) {
            Color color = graphics2D.getColor();
            graphics2D.setColor(this.color);
            graphics2D.draw(this.line);
            graphics2D.setColor(color);
        }

        public void setLocation(int n) {
            this.line.setRect(n, 0.0, 1.0, 800.0);
            this.setBoundsDirty();
            super.repaint();
        }
    }
}

