/*
 * Decompiled with CFR 0.152.
 */
package jass.engine;

import jass.engine.BufferNotAvailableException;
import jass.engine.Source;

public abstract class Out
implements Source {
    private long currentTime;
    protected int bufferSize;
    protected float[] buf;

    public Out(int n) {
        this.bufferSize = n;
        this.setTime(0L);
        this.buf = new float[n];
        this.clearBuffer();
    }

    public void setTime(long l) {
        this.currentTime = l;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    protected abstract void computeBuffer();

    public void clearBuffer() {
        for (int i = 0; i < this.bufferSize; ++i) {
            this.buf[i] = 0.0f;
        }
    }

    public synchronized float[] getBuffer(long l) throws BufferNotAvailableException {
        if (l == this.currentTime + 1L) {
            this.setTime(l);
            this.computeBuffer();
        } else if (l != this.currentTime) {
            System.out.println("Error! " + this + " Out.java: t=" + l + " currentTime=" + this.currentTime);
            throw new BufferNotAvailableException();
        }
        return this.buf;
    }
}

