/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.motion2d;

import edu.colorado.phet.common.phetcommon.application.ApplicationConstructor;
import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.view.util.FrameSetup;
import edu.colorado.phet.common.piccolophet.PiccoloPhetApplication;
import edu.colorado.phet.motion2d.Motion2DSimulationPanel;
import java.io.IOException;

public class Motion2DApplication
extends PiccoloPhetApplication {
    public Motion2DApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig);
        Motion2DModule motion2DModule = new Motion2DModule(phetApplicationConfig);
        this.addModule(motion2DModule);
    }

    public static void main(String[] stringArray) {
        Motion2DApplicationConfig motion2DApplicationConfig = new Motion2DApplicationConfig(stringArray);
        new PhetApplicationLauncher().launchSim(motion2DApplicationConfig, new ApplicationConstructor(){

            public PhetApplication getApplication(PhetApplicationConfig phetApplicationConfig) {
                return new Motion2DApplication(phetApplicationConfig);
            }
        });
    }

    public static class Motion2DApplicationConfig
    extends PhetApplicationConfig {
        public Motion2DApplicationConfig(String[] stringArray) {
            super(stringArray, "motion-2d");
            this.setFrameSetup(new FrameSetup.CenteredWithSize(850, 600));
        }
    }

    private class Motion2DModule
    extends Module {
        public Motion2DModule(PhetApplicationConfig phetApplicationConfig) {
            super(phetApplicationConfig.getName(), new ConstantDtClock(20, 0.021));
            Motion2DSimulationPanel motion2DSimulationPanel = new Motion2DSimulationPanel((ConstantDtClock)this.getClock());
            try {
                motion2DSimulationPanel.init();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.setSimulationPanel(motion2DSimulationPanel);
            this.setClockControlPanel(null);
            this.setLogoPanelVisible(false);
        }
    }
}

