/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.motion2d;

public class Motion2DModel {
    private Motion2DValue x;
    private Motion2DValue y;

    public Motion2DModel(int n, int n2) {
        this.x = new Motion2DValue(3 * n2 + 2 * n, n, n2);
        this.y = new Motion2DValue(3 * n2 + 2 * n, n, n2);
    }

    public void addPointAndUpdate(int n, int n2) {
        this.x.addPointAndUpdate(n);
        this.y.addPointAndUpdate(n2);
    }

    public double getXVel() {
        return this.x.getVelocity();
    }

    public double getYVel() {
        return this.y.getVelocity();
    }

    public double getXAcc() {
        return this.x.getAcceleration();
    }

    public double getYAcc() {
        return this.y.getAcceleration();
    }

    public double getAvgXMid() {
        return this.x.getAvgMid();
    }

    public double getAvgYMid() {
        return this.y.getAvgMid();
    }

    private static class Motion2DValue {
        double avgBefore;
        double avgMid;
        double avgNow;
        double[] value;
        double[] avg;
        private int halfWindowSize;
        private int numPtsAvg;

        public Motion2DValue(int n, int n2, int n3) {
            this.halfWindowSize = n2;
            this.numPtsAvg = n3;
            this.value = new double[n];
            this.avg = new double[n - 2 * n2];
            for (int i = 0; i < n; ++i) {
                this.value[i] = 100.0;
            }
        }

        public void addPoint(double d) {
            int n;
            int n2 = this.value.length;
            for (n = 0; n < n2 - 1; ++n) {
                this.value[n] = this.value[n + 1];
            }
            this.value[n2 - 1] = d;
            for (n = 0; n < n2 - 2 * this.halfWindowSize; ++n) {
                this.avg[n] = 0.0;
                for (int i = -this.halfWindowSize; i <= this.halfWindowSize; ++i) {
                    int n3 = n;
                    this.avg[n3] = this.avg[n3] + this.value[n + this.halfWindowSize + i];
                }
                this.avg[n] = this.avg[n] / (double)(2 * this.halfWindowSize + 1);
            }
        }

        public void updateAverages() {
            int n;
            int n2 = this.value.length;
            int n3 = n2 - 2 * this.halfWindowSize;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            for (n = 0; n <= this.numPtsAvg - 1; ++n) {
                d += this.avg[n];
            }
            this.avgBefore = d / (double)this.numPtsAvg;
            for (n = (n3 - this.numPtsAvg) / 2; n <= (n3 + this.numPtsAvg - 2) / 2; ++n) {
                d2 += this.avg[n];
            }
            this.avgMid = d2 / (double)this.numPtsAvg;
            for (n = n3 - this.numPtsAvg; n <= n3 - 1; ++n) {
                d3 += this.avg[n];
            }
            this.avgNow = d3 / (double)this.numPtsAvg;
        }

        public double getVelocity() {
            return this.avgNow - this.avgBefore;
        }

        public double getAcceleration() {
            return this.avgNow - 2.0 * this.avgMid + this.avgBefore;
        }

        public double getAvgMid() {
            return this.avgMid;
        }

        public void addPointAndUpdate(int n) {
            this.addPoint(n);
            this.updateAverages();
        }
    }
}

