/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.movingman.view;

import edu.colorado.phet.common.motion.charts.MotionSliderNode;
import edu.colorado.phet.common.motion.charts.PlayAreaSliderControl;
import edu.colorado.phet.common.motion.charts.TextBox;
import edu.colorado.phet.common.phetcommon.model.property.BooleanProperty;
import edu.colorado.phet.movingman.MovingManColorScheme;
import edu.colorado.phet.movingman.MovingManStrings;
import edu.colorado.phet.movingman.model.MovingMan;
import edu.colorado.phet.movingman.model.MovingManModel;
import edu.colorado.phet.movingman.model.MovingManState;
import edu.colorado.phet.movingman.view.MovingManChartControl;
import edu.colorado.phet.movingman.view.MovingManSimulationPanel;
import edu.colorado.phet.movingman.view.ShowVectorCheckBox;
import edu.colorado.phet.movingman.view.TextBoxListener;
import edu.colorado.phet.recordandplayback.model.RecordAndPlaybackModel;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MovingManSimulationPanelWithPlayAreaSliders
extends MovingManSimulationPanel {
    protected PlayAreaSliderControl positonSlider;
    protected PlayAreaSliderControl velocitySlider;
    protected PlayAreaSliderControl accelerationSlider;
    public static int DISTANCE_BETWEEN_SLIDERS = 20;

    @Override
    protected double getTimeReadoutOffsetY() {
        return -this.timeReadout.getFullBounds().getHeight();
    }

    public MovingManSimulationPanelWithPlayAreaSliders(final MovingManModel movingManModel, RecordAndPlaybackModel<MovingManState> recordAndPlaybackModel, BooleanProperty booleanProperty) {
        super(movingManModel, recordAndPlaybackModel, 100, booleanProperty);
        Object object = new TextBox(MovingManChartControl.TEXT_BOX_FONT);
        new TextBoxListener.Position(movingManModel).addListeners((TextBox)object);
        this.positonSlider = new PlayAreaSliderControl(-10.0, 10.0, movingManModel.getMousePosition(), MovingManStrings.POSITION, MovingManStrings.UNITS_METERS_ABBREVIATION, MovingManColorScheme.POSITION_COLOR, (TextBox)object);
        movingManModel.getMovingMan().addListener(new MovingMan.Listener(){

            public void changed() {
                MovingManSimulationPanelWithPlayAreaSliders.this.positonSlider.setHighlighted(movingManModel.getMovingMan().isPositionDriven());
            }
        });
        this.positonSlider.setHighlighted(movingManModel.getMovingMan().isPositionDriven());
        movingManModel.addListener(new MovingManModel.Listener(){

            public void mousePositionChanged() {
                MovingManSimulationPanelWithPlayAreaSliders.this.positonSlider.setValue(movingManModel.getMousePosition());
            }
        });
        this.positonSlider.addListener(new MotionSliderNode.Adapter(){

            public void sliderDragged(Double d) {
                movingManModel.getMovingMan().setPositionDriven();
                movingManModel.setMousePosition(d);
            }
        });
        ComponentAdapter componentAdapter = new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                MovingManSimulationPanelWithPlayAreaSliders.this.positonSlider.setOffset((double)(MovingManSimulationPanelWithPlayAreaSliders.this.getWidth() / 2) - MovingManSimulationPanelWithPlayAreaSliders.this.positonSlider.getFullBounds().getWidth() / 2.0, 100.0 + MovingManSimulationPanelWithPlayAreaSliders.this.getRulerHeight() + (double)DISTANCE_BETWEEN_SLIDERS);
            }
        };
        this.addComponentListener(componentAdapter);
        componentAdapter.componentResized(null);
        this.addScreenChild(this.positonSlider);
        object = new TextBox(MovingManChartControl.TEXT_BOX_FONT);
        new TextBoxListener.Velocity(movingManModel).addListeners((TextBox)object);
        this.velocitySlider = new PlayAreaSliderControl(-10.0, 10.0, movingManModel.getMovingMan().getVelocity(), MovingManStrings.VELOCITY, MovingManStrings.UNITS_VELOCITY_ABBREVIATION, MovingManColorScheme.VELOCITY_COLOR, (TextBox)object);
        movingManModel.getMovingMan().addListener(new MovingMan.Listener(){

            public void changed() {
                MovingManSimulationPanelWithPlayAreaSliders.this.velocitySlider.setValue(movingManModel.getMovingMan().getVelocity());
                MovingManSimulationPanelWithPlayAreaSliders.this.velocitySlider.setHighlighted(movingManModel.getMovingMan().isVelocityDriven());
            }
        });
        this.velocitySlider.addListener(new MotionSliderNode.Adapter(){

            public void sliderDragged(Double d) {
                movingManModel.getMovingMan().setVelocityDriven();
                movingManModel.getMovingMan().setVelocity(d);
            }
        });
        componentAdapter = new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                MovingManSimulationPanelWithPlayAreaSliders.this.velocitySlider.setOffset((double)(MovingManSimulationPanelWithPlayAreaSliders.this.getWidth() / 2) - MovingManSimulationPanelWithPlayAreaSliders.this.velocitySlider.getFullBounds().getWidth() / 2.0, MovingManSimulationPanelWithPlayAreaSliders.this.positonSlider.getFullBounds().getMaxY() + (double)DISTANCE_BETWEEN_SLIDERS);
            }
        };
        componentAdapter.componentResized(null);
        this.addComponentListener(componentAdapter);
        this.addScreenChild(this.velocitySlider);
        final PSwing pSwing = new PSwing(new ShowVectorCheckBox(MovingManStrings.VELOCITY_VECTOR, movingManModel.getVelocityVectorVisible()));
        pSwing.setOffset(this.velocitySlider.getFullBounds().getMaxX() + 10.0, this.velocitySlider.getFullBounds().getCenterY() - pSwing.getFullBounds().getHeight() / 2.0);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                pSwing.setOffset(MovingManSimulationPanelWithPlayAreaSliders.this.velocitySlider.getFullBounds().getMaxX() + 10.0, MovingManSimulationPanelWithPlayAreaSliders.this.velocitySlider.getFullBounds().getCenterY() - pSwing.getFullBounds().getHeight() / 2.0);
            }
        });
        this.addScreenChild(pSwing);
        object = new TextBox(MovingManChartControl.TEXT_BOX_FONT);
        new TextBoxListener.Acceleration(movingManModel).addListeners((TextBox)object);
        this.accelerationSlider = new PlayAreaSliderControl(-10.0, 10.0, movingManModel.getMovingMan().getAcceleration(), MovingManStrings.ACCELERATION, MovingManStrings.UNITS_ACCELERATION_ABBREVIATION, MovingManColorScheme.ACCELERATION_COLOR, (TextBox)object);
        movingManModel.getMovingMan().addListener(new MovingMan.Listener(){

            public void changed() {
                MovingManSimulationPanelWithPlayAreaSliders.this.accelerationSlider.setValue(movingManModel.getMovingMan().getAcceleration());
                MovingManSimulationPanelWithPlayAreaSliders.this.accelerationSlider.setHighlighted(movingManModel.getMovingMan().isAccelerationDriven());
            }
        });
        this.accelerationSlider.addListener(new MotionSliderNode.Adapter(){

            public void sliderDragged(Double d) {
                movingManModel.getMovingMan().setAccelerationDriven();
                movingManModel.getMovingMan().setAcceleration(d);
            }
        });
        componentAdapter = new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                MovingManSimulationPanelWithPlayAreaSliders.this.accelerationSlider.setOffset((double)(MovingManSimulationPanelWithPlayAreaSliders.this.getWidth() / 2) - MovingManSimulationPanelWithPlayAreaSliders.this.accelerationSlider.getFullBounds().getWidth() / 2.0, MovingManSimulationPanelWithPlayAreaSliders.this.velocitySlider.getFullBounds().getMaxY() + (double)DISTANCE_BETWEEN_SLIDERS);
            }
        };
        componentAdapter.componentResized(null);
        this.addComponentListener(componentAdapter);
        this.addScreenChild(this.accelerationSlider);
        pSwing = new PSwing(new ShowVectorCheckBox(MovingManStrings.ACCELERATION_VECTOR, movingManModel.getAccelerationVectorVisible()));
        pSwing.setOffset(this.accelerationSlider.getFullBounds().getMaxX() + 10.0, this.accelerationSlider.getFullBounds().getCenterY() - pSwing.getFullBounds().getHeight() / 2.0);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                pSwing.setOffset(MovingManSimulationPanelWithPlayAreaSliders.this.accelerationSlider.getFullBounds().getMaxX() + 10.0, MovingManSimulationPanelWithPlayAreaSliders.this.accelerationSlider.getFullBounds().getCenterY() - pSwing.getFullBounds().getHeight() / 2.0);
            }
        });
        this.addScreenChild(pSwing);
        object = new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                MovingManSimulationPanelWithPlayAreaSliders.this.getLayer().setOffset(0.0, MovingManSimulationPanelWithPlayAreaSliders.this.getHeight() / 2 - 100);
            }
        };
        this.addComponentListener((ComponentListener)object);
        ((ComponentAdapter)object).componentResized(null);
    }
}

