/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.javaversionchecker;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;

public class JavaVersionChecker {
    public static void main(String[] stringArray) throws IOException, InvocationTargetException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException {
        String string = System.getProperty("java.version");
        if (string.startsWith("1.4") || string.startsWith("1.3") || string.startsWith("1.2") || string.startsWith("1.1")) {
            JavaVersionChecker.showJavaVersionErrorDialog();
        } else {
            JavaVersionChecker.launchApplication(stringArray);
        }
    }

    private static void launchApplication(String[] stringArray) throws ClassNotFoundException, InvocationTargetException, IOException, NoSuchMethodException, IllegalAccessException {
        Class<?> clazz = Class.forName("edu.colorado.phet.common.phetcommon.application.JARLauncher");
        Method method = clazz.getMethod("main", stringArray.getClass());
        method.invoke(null, new Object[]{stringArray});
    }

    private static void showJavaVersionErrorDialog() throws IOException {
        String string = System.getProperty("java.version");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        String string2 = "<html>PhET requires Java 1.5 or higher.<br>You have Java " + n + "." + n2 + ".<br>" + "<br>" + "Please visit <a href=\"http://www.java.com\">www.java.com</a> to get the latest version of Java.</html>";
        JEditorPane jEditorPane = new JEditorPane("text/html", string2);
        jEditorPane.setEditorKit(new HTMLEditorKit());
        jEditorPane.setText(string2);
        jEditorPane.setEditable(false);
        jEditorPane.setBackground(new JPanel().getBackground());
        jEditorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        JavaVersionChecker.getBasicService().showDocument(hyperlinkEvent.getURL());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
        JFrame jFrame = new JFrame("Java Version");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jEditorPane, "Center");
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton("Exit");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jPanel2.add(jButton);
        jPanel.add((Component)jPanel2, "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jFrame.setContentPane(jPanel);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        jFrame.setLocation((int)(dimension.getWidth() / 2.0 - (double)(jFrame.getWidth() / 2)), (int)(dimension.getHeight() / 2.0 - (double)(jFrame.getHeight() / 2)));
        jFrame.setVisible(true);
    }

    public static boolean isJavaWebStart() {
        return System.getProperty("javawebstart.version") != null;
    }

    public static BasicService getBasicService() throws Exception {
        if (JavaVersionChecker.isJavaWebStart()) {
            return (BasicService)ServiceManager.lookup((String)BasicService.class.getName());
        }
        return new LocalBasicService();
    }

    private static class LocalBasicService
    implements BasicService {
        private LocalBasicService() {
        }
    }
}

