/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.flashlauncher;

import edu.colorado.phet.flashlauncher.FlashHTML;
import edu.colorado.phet.flashlauncher.util.BareBonesBrowserLaunch;
import edu.colorado.phet.flashlauncher.util.FileUtils;
import edu.colorado.phet.flashlauncher.util.SimulationProperties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class FlashLauncher {
    private String deployment = "standalone-jar";
    private String distributionTag = "null";
    private String installationTimestamp = "null";
    private String installerCreationTimestamp = "null";
    private static JTextArea jTextArea;
    private final SimulationProperties simulationProperties = new SimulationProperties();

    public FlashLauncher() throws IOException {
        if (this.simulationProperties.isDevelopment()) {
            FlashLauncher.println("FlashLauncher.FlashLauncher dev");
            JFrame jFrame = new JFrame("Text");
            jTextArea = new JTextArea(10, 50);
            jFrame.setContentPane(new JScrollPane(jTextArea));
            jFrame.setVisible(true);
            jFrame.setDefaultCloseOperation(3);
            jFrame.setSize(800, 600);
        }
    }

    public static void println(String string) {
        System.out.println(string);
        if (jTextArea != null) {
            jTextArea.append(string + "\n");
        }
    }

    private void start(String[] stringArray) throws IOException {
        FlashLauncher.println("FlashLauncher.start");
        String string = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "phet-" + this.simulationProperties.getSimulation();
        FlashLauncher.println("unzipping to directory = " + string);
        File file = new File(string);
        File file2 = this.getJARFile();
        FlashLauncher.println("jarfile = " + file2);
        FlashLauncher.println("Starting unzip jarfile=" + file2 + ", unzipDir=" + file);
        FileUtils.unzip(file2, file);
        FlashLauncher.println("Finished unzip");
        Properties properties = FlashLauncher.readProperties(this.simulationProperties.getProject());
        String string2 = properties.getProperty("version.major");
        String string3 = properties.getProperty("version.minor");
        String string4 = properties.getProperty("version.dev");
        String string5 = properties.getProperty("version.revision");
        String string6 = properties.getProperty("version.timestamp");
        if (properties.getProperty("distribution.tag") != null) {
            this.distributionTag = properties.getProperty("distribution.tag");
        }
        if (this.simulationProperties.getSimulation().equals("flash-common-strings")) {
            String string7 = "";
            string7 = string7 + "PhET Flash common strings : version ";
            string7 = string7 + string2 + "." + string3 + "." + string4 + " (" + string5 + ")";
            string7 = string7 + "\n\n";
            string7 = string7 + "This JAR file contains common strings used by all PhET Flash simulations.\nYou can use this JAR file to translate common strings with Translation Utility.\nBut testing those translations is not currently supported.";
            JOptionPane.showMessageDialog(null, string7);
            return;
        }
        String string8 = FlashLauncher.readBackgroundColor(properties);
        String string9 = "false";
        if (!string4.equals("0") && !string4.equals("00")) {
            string9 = "true";
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-dev")) continue;
            string9 = "true";
        }
        String string10 = FlashHTML.localeString(this.simulationProperties.getLanguage(), this.simulationProperties.getCountry());
        File file3 = this.getSimXMLFile(file, string10);
        File file4 = new File(file, "common-strings_" + string10 + ".xml");
        if (!file4.exists()) {
            file4 = new File(file, "common-strings_en.xml");
            FlashLauncher.println("WARNING: could not find common strings for " + string10 + ", using default en.");
        }
        String string11 = FlashHTML.rawFile(new File(file, "credits.txt"));
        String string12 = FlashHTML.encodeXMLFile(file3);
        String string13 = FlashHTML.encodeXMLFile(file4);
        Properties properties2 = FlashLauncher.readProperties("software-agreement");
        String string14 = properties2.getProperty("version");
        String string15 = FlashHTML.rawFile(new File(file, "software-agreement.htm"));
        String string16 = FlashHTML.encodeXML(string15);
        String string17 = this.simulationProperties.getSimulation();
        String string18 = this.simulationProperties.getProject();
        String string19 = FlashHTML.extractTitleFromXML(string17, file3);
        if (string19 == null && (string19 = FlashHTML.extractTitleFromXML(string17, new File(file, string17 + "-strings_en.xml"))) == null) {
            string19 = string17;
        }
        String string20 = FlashHTML.generateHTML(string18, string17, this.simulationProperties.getLanguage(), this.simulationProperties.getCountry(), this.deployment, this.distributionTag, this.installationTimestamp, this.installerCreationTimestamp, string2, string3, string4, string5, string6, string9, string8, string12, string13, "8", "flash-template.html", string14, string16, string11, string19);
        File file5 = new File(file, string17 + "_" + string10 + ".html");
        FileOutputStream fileOutputStream = new FileOutputStream(file5);
        fileOutputStream.write(string20.getBytes());
        fileOutputStream.close();
        FlashLauncher.println("Starting openurl");
        BareBonesBrowserLaunch.openURL("file://" + file5.getAbsolutePath());
    }

    private File getSimXMLFile(File file, String string) {
        File file2 = new File(file, this.simulationProperties.getProject() + "-strings_" + string + ".xml");
        if (!file2.exists()) {
            file2 = new File(file, this.simulationProperties.getProject() + "-strings_en.xml");
            FlashLauncher.println("WARNING: could not find sim strings for " + string + ", using default en.");
        }
        return file2;
    }

    private static Properties readProperties(String string) {
        String string2 = string + ".properties";
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string2);
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return properties;
    }

    private static String readBackgroundColor(Properties properties) {
        String string = properties.getProperty("bgcolor");
        if (string == null) {
            string = "#ffffff";
        }
        return string;
    }

    private File getJARFile() {
        URL uRL = FlashLauncher.class.getProtectionDomain().getCodeSource().getLocation();
        try {
            return new File(URLDecoder.decode(uRL.getFile(), "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            try {
                return new File(URLDecoder.decode(uRL.getPath(), "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                unsupportedEncodingException2.printStackTrace();
                return new File(uRL.getPath());
            }
        }
    }

    public static void main(String[] stringArray) throws IOException {
        System.out.println("FlashLauncher.main started");
        new FlashLauncher().start(stringArray);
        System.out.println("FlashLauncher.main finished");
    }
}

