/* =====================================================================================

offline SCORM tester

======================================================================================== */

var pipwerks = {};

pipwerks.data = { 'cmi.launch_data' : 'QWERTY12345' };

pipwerks.UTILS = {};	

pipwerks.SCORM = { connection: {}, data: {}, debug: {} };

pipwerks.SCORM.isAvailable = function(){ return true; };

pipwerks.SCORM.connection.initialize = function(){ pipwerks.UTILS.trace('connect'); return true; };

pipwerks.SCORM.connection.terminate = function(){ pipwerks.UTILS.trace('disconnect'); return true; };

pipwerks.SCORM.data.get = function(parameter){
	pipwerks.UTILS.trace('get: '+parameter+' > '+pipwerks.data[parameter]);
	return pipwerks.data[parameter];
};

pipwerks.SCORM.data.set = function(parameter, value){
	pipwerks.UTILS.trace('set: '+parameter+' to: '+value);
	pipwerks.data[parameter] = value;
	return true;
};

pipwerks.SCORM.data.save = function(){ 
	pipwerks.UTILS.trace('save');
	return true;
};

pipwerks.SCORM.status = function (action, status) {
	pipwerks.UTILS.trace(action);
	pipwerks.UTILS.trace(status);
	return true;
};

pipwerks.SCORM.debug.getCode = function(){ return 0; };

pipwerks.SCORM.debug.getInfo = function(errorCode){ return 'getInfo'; };

pipwerks.SCORM.debug.getDiagnosticInfo = function(errorCode){ return 'getDiagnosticInfo'; };

pipwerks.SCORM.init = pipwerks.SCORM.connection.initialize;
pipwerks.SCORM.get  = pipwerks.SCORM.data.get;
pipwerks.SCORM.set  = pipwerks.SCORM.data.set;
pipwerks.SCORM.save = pipwerks.SCORM.data.save;
pipwerks.SCORM.quit = pipwerks.SCORM.connection.terminate;

pipwerks.UTILS.StringToBoolean = function(string){
     switch(string.toLowerCase()) {
          case "true": case "yes": case "1": return true;
          case "false": case "no": case "0": case null: return false; 
          default: return Boolean(string);
     }     
};

pipwerks.UTILS.trace = function(msg){
	if(window.console){
		console.log(msg);
	}
};





