$(function() {
    var menuElement = $('#menu');
    var menuItems = menuElement.find('a');
    var pagesContainer = $('#pages');
    var pages = pagesContainer.children('div');
    var containerElement = $('#container');
    var gameElement = $('#nowa-gra');
    var numberBiggerElement = $('#number-bigger');
    var numberSmallerElement = $('#number-smaller');
    var grajElement = $('#graj');
    var gameProgressElement = $('#game-progress');
    var gameProgressContainerElement = $('#game-progress-container').perfectScrollbar({wheelSpeed: 40});
    var multipleChooseElement = $('#multiple-choose').hide();
    var gameProgressRowElement = gameProgressElement.find('tr').hide();
    var wygralesElement = $('#wygrales');
    var multiplerElement = $('#multipler');
    var whatNowElement = $('#what-now');

    var playaudio = (function() {
        var click = new Audio('audio/click.wav');
        var wrong = new Audio('audio/wrong.wav');
        var good = new Audio('audio/good.wav');
        var play = function(audio) {
            audio.pause();
            audio.currentTime = 0;
            audio.play();
        };
        return {
            click: function() {
                play(click);
            },
            wrong: function() {
                play(wrong);
            },
            good: function() {
                play(good);
            }
        };
    })();
    $.fn.extend({
        clickable: function(clickfunction, removeAfterClick) {
            var self = this;
            removeAfterClick = removeAfterClick || false;
            clickfunction = clickfunction || function() {
            };

            return self.addClass('clickable').on('click', function() {
                playaudio.click();
                clickfunction.apply(this, arguments);
                if (removeAfterClick) {
                    self.unclickable();
                }
            });
        },
        unclickable: function() {
            return this.removeClass('clickable').off('click');
        }
    });
    pages.hide();
    var popup = {
        container: containerElement,
        elements: [],
        killPopups: function() {
            while (this.elements.length) {
                var $element = this.elements.pop();
                $element.fadeOut(function() {
                    $element.remove();
                });
            }
        },
        popupWindow: function(content, onClose) {
            menuElement.fadeOut();
            // append overlay
            var overlay = $('<div />').css({
                opacity: 0.5,
                background: '#000',
                width: 1000,
                height: 750,
                position: 'absolute',
                left: 0,
                top: 0
            }).hide().fadeIn();
            content = $('<div />').html(content);
            content.css({
                position: 'absolute'
            });
            this.container.append(overlay);
            this.container.append(content);
            this.container.width();
            content.addClass('popup-window').hide().fadeIn();

            if (onClose) {
                var $ui = this;

                var $closeButton = $('<div></div>').addClass('close-button');
                $closeButton.clickable(function() {
                    $ui.killPopups();
                    menuElement.fadeIn();
                    if (typeof onClose === 'function') {
                        onClose();
                    }
                });
                content.append($closeButton);
            }
            this.elements.push(overlay, content);
        }
    };

    var APIHelper = (function() {
        var apiURL = '/CommunicationService.svc';
        var sessionIdRegexResult = location.search.match(/[\d\w]{8}-[\d\w]{4}-[\d\w]{4}-[\d\w]{4}-[\d\w]{12}/);
        var sessionId = null;
        if (sessionIdRegexResult) {
            sessionId = sessionIdRegexResult[0];
        }
        return {
            saveResult: function(percent, callback, error) {
                if (!sessionId) {
                    return false;
                }
                var result = 0;
                var hash = CryptoJS.MD5(sessionId + result + percent).toString();
                var data = [apiURL, 'saveresult', sessionId, result, percent];
                var ajaxURL = data.join('/');
                $.ajax({
                    url: ajaxURL + '?hash=' + hash,
                    data: {
                        hash: hash
                    },
                    success: callback,
                    error: error,
                    cache: false
                });
            },
            getHighscores: function(callback, error) {
                if (!sessionId) {
                    // offline mode. skip and send false to callback function
                    callback(false);
                    return false;
                }
                var data = [apiURL, 'gettopscores', sessionId];
                var ajaxURL = data.join('/');
                $.ajax({
                    url: ajaxURL,
                    success: callback,
                    error: error,
                    dataType: 'xml',
                    cache: false
                });
            }
        };
    })();
    var showPopup = function(element, onclose) {
        var href = $(element).attr('href'),
                pageContent = $(href);
        if (pageContent.hasClass('popup')) {
            var content = pageContent.clone();
            switch (href) {
                case '#najlepsi':
                    var status = content.find('#top-players-status').text('Trwa wczytywanie danych...');
                    APIHelper.getHighscores(function(data) {
                        var topPlayers = content.find('#top-players');
                        var list = '';
                        $.each($(data).find('UserScore'), function(key, value) {
                            var $value = $(value);
                            list += '<li>' + $value.find('Nick').text() + ', wynik: '+ $value.find('Result').text() +'</li>';
                        });
                        if (list === '') {
                            status.text('Brak wyników');
                        } else {
                            topPlayers.html(list);
                            status.text('');
                        }
                    }, function() {
                        status.text('Wystąpił błąd');
                    });
                    break;
            }
            if (typeof onclose !== 'function') {
                onclose = true;
            }
            popup.popupWindow(content.show(), onclose);
        } else {
            switch (href) {
                case '#nowa-gra':
                case '#restart':
                    (new game).play();
                    break;
            }
        }
    };
    menuItems.clickable(function(e) {
        e.preventDefault();
        showPopup(this);
    });
    showPopup(menuItems.first(), function() {
        (new game).play();
    });
    gameElement.show();

    var timeoutId;

    var game = function() {
        var wins = 0;
        var looses = 0;
        var WINS_TO_FINISH = 3;
        var number1;
        var number2;
        var numberList = [
            100,
            146,
            211,
            269,
            294,
            330,
            388,
            401,
            452,
            594,
            597,
            650,
            674,
            740,
            777,
            831,
            911,
            922,
            944,
            981
        ];

        var getBigger = function() {
            return Math.max(number1, number2);
        };
        var getSmaller = function() {
            return Math.min(number1, number2);
        };
        var minusBigger = function(value) {
            if (number1 >= number2) {
                number1 -= value;
                return number1;
            } else {
                number2 -= value;
                return number2;
            }
        };
        var getMultiple = function(number, lessThan) {
            var multiple = Math.floor(lessThan / number);
            var data = [];
            for (var i = 0; i < multiple; i++) {
                data.push(i + 1);
            }
            return data;
        };

        var players = ['computer', 'human'];
        var currentPlayer = players[0];
        var switchPlayer = function() {
            for (var i = 0; i < players.length; i++) {
                if (players[i] === currentPlayer) {
                    if (players.length - 1 === i) {
                        currentPlayer = players[0];
                    } else {
                        currentPlayer = players[i + 1];
                    }
                    return currentPlayer;
                }
            }
        };

        var playerMove = function(number) {
         
            var bigger = getBigger();
            var smaller = getSmaller();
            var multipleList = getMultiple(smaller, bigger);
            if (number in multipleList) {
                var minus = multipleList[number];
                var newvalue = minusBigger(minus * smaller);
                if (newvalue > 0) {
                    switchPlayer();
                }
                return newvalue;
            }
            return false;
        };

        var finishCallback = function(nextPlay) {
            
            if (currentPlayer === 'human') {
                wygralesElement.fadeIn('normal', function() {
                    setTimeout(function() {
                        wygralesElement.fadeOut();
                    }, 3000);
                });
                playaudio.good();
                wins++;
            } else {
                playaudio.wrong();
                looses++;
            }
            if (wins === WINS_TO_FINISH || (wins + looses) === 5) {
                var result = 33 * wins;
                if (wins === 99) {
                    wins++;
                }
                APIHelper.saveResult(result, function(data) {
                    popup.popupWindow('<p>Koniec! Wygranych: ' + wins + '. Wynik przesłany</p>', true);
                }, function() {
                    popup.popupWindow('<p>Koniec! Wygranych: ' + wins + '. Błąd podczas przesyłania wyniku</p>', true);
                });

            } else {
                popup.popupWindow('Wygranych: ' + wins + '/' + WINS_TO_FINISH, function() {
                    nextPlay();
                });
            }
        };

        var publicMethods = {
            play: function() {
                currentPlayer = players[0];
                if (timeoutId) {
                    clearTimeout(timeoutId);
                }
                
                var multipleChooseFill2 = function(clickable, data, callback) {
                    clickable.clickable(function() {
                        var html = '';
                        $.each(data, function(i, element) {
                            html += '<li>' + element + '</li>';
                        });
                        gameProgressContainerElement.addClass('hide');

                        multipleChooseElement.html(html).fadeIn().find('li').clickable(function() {
                            var value = parseInt($(this).text());
                            multipleChooseElement.fadeOut(function() {
                                multipleChooseElement.text('');
                                gameProgressContainerElement.removeClass('hide');
                                clickable.text(value);
                                callback(value);
                            });
                        }, true);
                    }, true);
                };

                numberSmallerElement.text('');
                numberBiggerElement.text('');
                multiplerElement.text('');
                wygralesElement.hide();
                gameProgressElement.html(gameProgressRowElement);
                var gameTurn=0;

                function gameMove(finishCallback) {
                    gameTurn++;
                    var gameProgressRow = gameProgressRowElement.clone().fadeIn();
                    var smaller = getSmaller();
                    var bigger = getBigger();
                    var multipleData = getMultiple(smaller, bigger);

                    $('#game-progress-container').scrollTop(0); 

                    var buildMultiple = function(data, callback) {
                        if (data.length === 1) {
                            callback(data.length);
                            return;
                        }
                        var cellMultipler = gameProgressRow.find('.multipler');
                        var html = '';
                        for (var i = 0; i < data.length; i++) {
                            html += '<li><span>' + data[i] + '</span>&times</li>';
                        }
                        var position = cellMultipler.position();
                        multiplerElement.css({top: position.top, left: position.left}).html(html).fadeIn().find('li').clickable(function() {
                            multiplerElement.text('').fadeOut();
                            var value = parseInt($(this).find('span').text());
                            callback(value);
                            cellMultipler.css('width', 'auto');
                        }, true);
                        cellMultipler.width(multiplerElement.width());
                    };

                    if (currentPlayer === 'computer') {
                        gameProgressRow.addClass('computer');
                        gameProgressRow.find('.player div').html('&nbsp;&nbsp;&nbsp;Ruch komputera');
                    }

                    gameProgressElement.append(gameProgressRow);
                    gameProgressRow.find('.bigger').text(bigger + ' -');
                    gameProgressRow.find('.smaller').text(smaller);


                    var playerMove2 = function(number) {
                        number--;
                        var prevPlayer = currentPlayer;
                        var minus = playerMove(number);
                        var checkChoice = function() {
                            var minusNumber = (number + 1) * smaller;
                            gameProgressRow.find('.result').text('= ' + (bigger - minusNumber));
                            if (minus > 0) {
                                gameMove(finishCallback);
                            } else {
                                finishCallback();
                            }
                        };

                        gameProgressRow.find('.multipler').html((number + 1) + '&times');
                        if (prevPlayer === 'human') {

                            var yourMoveElment = $('<img />').attr({
                                src: 'img/twoj-ruch.png'
                            }).hide();

                            gameProgressRow.find('.player div').html(yourMoveElment);
                            yourMoveElment.show('normal').clickable(function() {
                                yourMoveElment.hide('normal', function() {
                                    yourMoveElment.remove();
                                });
                                checkChoice();
                            }, true);
                        } else {
                            checkChoice();
                        }
                    };

                    var element = gameProgressContainerElement.get(0);
                    element.scrollTop = element.scrollHeight;

                    if (currentPlayer === 'computer') {
                        timeoutId = setTimeout(function() {
                            
                            if(gameTurn<4)value = Math.floor(Math.random()*(Math.floor(bigger/smaller)))+1;
                            else value = Math.floor(bigger/smaller);
                            playerMove2(value);
                        }, 2500);
                    } else {
                        buildMultiple(multipleData, playerMove2);
                    }
                }

                function blink(targetElement){
                  tBlink=setTimeout(function(){ blink(targetElement); },500);
                  $('#'+targetElement).animate({opacity: 0.8},250).animate({opacity: 1},250); 
                }
                function unblink(){
                  clearTimeout(tBlink);                   
                }
                

                whatNowElement.text('Wybierz pierwszą karteczkę z liczbą');
                blink('number-bigger');
                multipleChooseFill2(numberBiggerElement, numberList, function(value) {
                    unblink();                  
                    number1 = value;
                    for (var i = 0; i < numberList.length; i++) {
                        if (numberList[i] === value) {
                            numberList.splice(i, 1);
                            break;
                        }
                    }
                    whatNowElement.text('Wybierz drugą karteczkę z liczbą');
                    blink('number-smaller');
                    multipleChooseFill2(numberSmallerElement, numberList, function(value) {
                        unblink();  
                        whatNowElement.text('');
                        number2 = value;
                        grajElement.show('normal').clickable(function() {
                            grajElement.hide('normal');
                            gameMove(function() {
                                finishCallback(publicMethods.play);
                            });
                        }, true);
                    });
                });
            }
        };
        return publicMethods;
    };
});
