

(function($,CryptoJS){
    if(!Array.prototype.last){
      // boost Array prototype with last()
      Array.prototype.last = function(){
        return this[this.length-1];
      }
    }
    var DEBUG_MODE = false;
    // temporary debugging proxy
    // local
    // var apiURL = 'proxy.php?url=CommunicationService.svc';
    var apiURL = 'http://gra.archipelagmatematyki.pl/CommunicationService.svc';
    var sessionIdRegexResult = location.search.match(/[\d\w]{8}-[\d\w]{4}-[\d\w]{4}-[\d\w]{4}-[\d\w]{12}/);
    var sessionId = null;
    if(sessionIdRegexResult){
      sessionId = sessionIdRegexResult[0];
    }
    if(location.search.match(/debug/)){
      DEBUG_MODE = true;
    }
    var APIHelper = function(){
        return {
            saveResult:function(score, percent, callback){
                if(!sessionId) {
                  // offline mode. abandon ship!
                  return false;
                }
                var hash = CryptoJS.MD5(sessionId+score+percent).toString();
                var ajaxURL = [apiURL,'saveresult', sessionId, score,percent].join('/');
                $.ajax({
                    
                    url:ajaxURL+'?hash='+hash,
                    success:callback
                });
            },
            getHighscores:function(callback){
                if(!sessionId) {
                  // offline mode. abandon ship! (and send false hope to callback function)
                  callback(false);
                  return false;
                }
                var ajaxURL = [apiURL,'gettopscores', sessionId].join('/');
                $.ajax({
                    url:ajaxURL,
                    success:callback
                });
            }            
        }
    }
    var UIHelper = function(){
        return {
            elements:[],
            app:{},
            backgroundColors:[
              '#fffcb7',
              '#ffffff',
              //'#ff3c3c',
              '#60ed93',
              '#c2e0f5',
              '#ecc5f1'
            ],
            createColorSelector:function(){
              var $ui = this;
              $.each(this.backgroundColors, function(i){
                var $innerDot = $('<div />').addClass('dot');
                var $outerDot = $('<div />').addClass('outer-dot').append($innerDot);
                if(i==0){
                  $outerDot.addClass('first');
                }
                if(i==$ui.backgroundColors.length-1){
                  $outerDot.addClass('last');
                }
                $innerDot.css({
                  background:this
                });
                $outerDot.on('click', function(){
                  $('#color-back-layer').css({
                    backgroundColor:$(this).find('.dot').css('backgroundColor')
                  });
                });
                $('#color-selector').append($outerDot);
              })
            },
            buildButton:function(label, onClick,audioId){
                var $button = $('<button />').attr({
                    type:'button'
                });
                $button.addClass('ui-button');
                $button.html(label);
                $button.data('onClick',$.proxy(onClick,$button));
                var $app = this.app;
                if(audioId !== undefined){
                    $button.on('click',function(){
                        $(this).data('onClick')();
                        $app.playSound(audioId);
                    });
                } else {
                    $button.on('click',onClick);
                }
                
                return $button;
            },
            titledContainer:function(title){
                var $container = $('<div />').addClass('ui-container ui-window');
                var $title = $('<h1 />').html(title);
                var $content = $('<div />').addClass('ui-content');
                $container.append($title, $content);
                return $container;
            },
            killPopups:function(){
                while(this.elements.length){
                    var $element = this.elements.pop();
                    $element.remove();
                }
                
            },
            popupWindow:function(content,onClose){
                // append overlay
                var $overlay = $('<div />').css({
                    opacity:0.5,
                    background:'#000',
                    width:1000,
                    height:800,
                    position:'absolute',
                    left:0,
                    top:0,
                    zIndex:500
                });
                content.css({
                    position:'absolute',
                    zIndex:501
                });
                this.container.append($overlay);
                this.container.append(content);
                this.container.width();
                content.addClass('popup-window');
                content.css({
                    left:(this.container.width()-content.outerWidth())/2,
                    top:(this.container.height()-content.outerHeight())/2,
                });
                
                if(onClose){
                    var $ui = this;
                    
                    var $closeButton = $('<div></div>').addClass('close-button');
                    $closeButton.on('click', function(){
                        
                        app.playSound('click2');
                        $ui.killPopups();
                        if(typeof onClose == 'function'){
                          onClose();
                        }
                    });
                    content.append($closeButton);
                }
                this.elements.push($overlay,content);
            }
        }
    }
    var symbols = ['empty','p_a','p_b','p_c','p_d','a','b','c','d','a_p','b_p','c_p','d_p','u','n','sub','op','cp',];
    var s = 0;
    
    var App = function(){
        return {
            maxScore:20,
            penalty:5,
            timePenalty:3,
            rollers:[],
            setElements:[],
            sets:{
              4:{
                parts:['4_a','4_anb-d','4_anbnd','4_and-auc','4_and-b','4_b','4_bnc-d','4_bndnc','4_c','4_cnd-b','4_d'],
                overlay:'ov',
                formulas:[
                  {
                    'formula':'(A n B n D) u (B n C n D)',
                    'parts':['4_anbnd', '4_bndnc']
                  },
                  {
                    'formula':'(C n (B u D) ) u (A n B)',
                    'parts':['4_bnc-d','4_cnd-b','4_bndnc','4_anb-d','4_anbnd']
                  },  
                  {
                    'formula':'(C n D) u (C n B)',
                    'parts':['4_cnd-b','4_bndnc','4_bnc-d']
                  },
                  {
                    'formula':'(B - A) u (D - C)',
                    'parts':['4_b','4_d','4_and-auc','4_and-b','4_anbnd','4_bnc-d','4_bndnc']
                  },
                  {
                    'formula':'( A n (B u D) ) u (B n D)',
                    'parts':['4_anb-d','4_anbnd','4_and-auc','4_and-b','4_bndnc']
                  },
                  {
                    'formula':'(C - B) u ( D - (B u A) )',
                    'parts':['4_c','4_cnd-b','4_d']
                  },
                ]
              },
              3:{
                parts:['3_a','3_anb-c','3_anbnc','3_anc-b','3_b','3_bnc-a','3_c'],
                overlay:'ov',                
                formulas:[
                  {
                    'formula':'A n (B - C)',
                    'parts':['3_anb-c']
                  },
                  {
                    'formula':'(A n B) - C)',
                    'parts':['3_anb-c']
                  },
                  {
                    'formula':'(A - C) n (B - C)',
                    'parts':['3_anb-c']
                  },
                  {
                    'formula':'A n B n C',
                    'parts':['3_anbnc']
                  },
                  {
                    'formula':'A - (B n C)',
                    'parts':['3_a','3_anc-b','3_anb-c']
                  },
                  {
                    'formula':'(A - B) u (A - C)',
                    'parts':['3_a','3_anc-b','3_anb-c']
                  },              
                  {
                    'formula':'(C n A) - B',
                    'parts':['3_anc-b']
                  },
                  {
                    'formula':'(A - B) n (C - B)',
                    'parts':['3_anc-b']
                  },
                  {
                    'formula':'A u (B - C)',
                    'parts':['3_a','3_anc-b','3_anb-c','3_anbnc','3_b']
                  },
                  {
                    'formula':'(A u B) - (A u C)',
                    'parts':['3_a','3_anc-b','3_anb-c','3_anbnc','3_b']
                  },
                  {
                    'formula':'(C - A) - B',
                    'parts':['3_c']
                  },
                  {
                    'formula':'(C - A) u (B - A)',
                    'parts':['3_c','3_bnc-a','3_b']
                  },
                  {
                    'formula':'(B u C) - A',
                    'parts':['3_c','3_bnc-a','3_b']
                  },
                  {
                    'formula':'(A n B) u (B n C) u (C n A)',
                    'parts':['3_anb-c','3_anc-b','3_bnc-a','3_anbnc']
                  },
                  {
                    'formula':'(A u B u C) - (A n B n C)',
                    'parts':['3_a','3_b','3_c','3_anb-c','3_anc-b','3_bnc-a']
                  },
                  {
                    'formula':'A - (B u C)',
                    'parts':['3_a']
                  },
                  {
                    'formula':'A u (B n C)',
                    'parts':['3_a','3_anc-b', '3_anb-c', '3_anbnc', '3_bnc-a']
                  },
                  {
                    'formula':'(A u B) n (A u C)',
                    'parts':['3_a','3_anc-b', '3_anb-c', '3_anbnc', '3_bnc-a']
                  },
                  {
                    'formula':'A n (B u C)',
                    'parts':['3_anb-c','3_anc-b','3_anbnc']
                  },
                  {
                    'formula':'(A n B) u (A n C)',
                    'parts':['3_anb-c','3_anc-b','3_anbnc']
                  },
                ],
              }
            },
            progressSessionVariableName:'gamestate-'+sessionId,
            loadSession:function(){
              if(sessionId){
                sessionData = $.cookie(this.progressSessionVariableName);
                if(sessionData){
                  this.gameProgress = $.parseJSON(sessionData);
                }
              }
           },
           symbolMap:{
            'A':'a',
            'B':'b',
            'C':'c',
            'D':'d',
            '(A':'p_a',
            '(B':'p_b',
            '(C':'p_c',
            '(D':'p_d',
            'A)':'a_p',
            'B)':'b_p',
            'C)':'c_p',
            'D)':'d_p',
            'u':'u',
            'n':'n',
            '-':'sub',
            '(':'op',
            ')':'cp',
            '0':'empty'
          },
          showRandomSets:function(parts){
            
            var parts = this.sets[this.gameState.setsSet].parts;
            var showCount = Math.floor(Math.random()*parts.length)+1;
            var addedItems = 0;
            var partsClonedArray = parts.slice(0);
            var randomParts = [];
            while(addedItems < showCount){
              var itemIndex = Math.floor(Math.random()*partsClonedArray.length);             
              var itemToAdd = partsClonedArray.splice(itemIndex,1)[0];
              randomParts.push(itemToAdd);
              addedItems++;
            }
            if(parts.sort().join(',') == randomParts.sort().join(',')){
              this.showRandomSets(parts);
            } else {
              this.showFormulaSets(randomParts);
            }
          },
          showFormulaSets:function(parts){
            var $app = this;
            var allParts = parts.concat([this.gameState.setsSet+'_ov']);
            $.each(allParts, function(){
              var $setElement = $('<div />').addClass('set');
              $setElement.append($('<img />').attr({
                src:'img/sets/'+this+'.png'
              }));
              $('#sets').append($setElement);
              $setElement.css({
                opacity:0
              });
              var elementDelay = Math.random()*300;
              $setElement.delay(elementDelay).animate({
                opacity:1
              }, {
                start:function(){
                  $app.playSound('led');
                },
                easing:'easeInBounce',
                duration:Math.random()*1000+1000
              });
            });
          },
          clearSets:function(){
            $('#sets *').each(function(){
              $(this).delay(Math.random()*200).fadeOut(400,function(){
                $(this).remove();
              });
            });
          },
          rollToEmpty:function(){
            this.playSound('roll');
            $.each(this.rollers, function(){
              this.data('rollTo')('empty');
            });
          },
          rollFormula:function(formula){
            // split symbols
            var $app = this;
            $app.clearSets();
            $app.canAnwser = false;
            var tokens = formula.formula.split(" ");
            // calculate justification
            var emptyLeft = Math.floor((this.rollers.length-tokens.length)/2);
            var emptyRight = this.rollers.length-(tokens.length+emptyLeft);

            for(var k=0;k<emptyLeft;k++){
              tokens.unshift('0');
            }
            for(k=0;k<emptyRight;k++){
              tokens.push('0');
            }
            var rollerIndex = 0;
            var symbolMap = this.symbolMap;
            var rollers = this.rollers;
            //$app.showFormulaSets(formula);
            //$app.showRandomSets();
            
            this.gameState.finishedRollers = 0;
            $.each(tokens, function(){
              var token = (String(this));

              rollers[rollerIndex].data('rollTo')(symbolMap[token], function(){
                $app.gameState.finishedRollers++;
                if($app.gameState.finishedRollers == $app.rollers.length){
                  // all rolled
                  // REFACTOR: move to callback instead of inline
                  $app.canAnwser = true;
                  var showGood = false;
                  if(DEBUG_MODE){
                    showGood = true;
                  } else {
                    if(Math.random()>=0.5){
                      showGood = true;
                    }
                  }
                  $app.gameState.showGood = showGood;
                  if(showGood){
                    $app.showFormulaSets(formula.parts);
                  } else {
                    $app.showRandomSets(formula.parts);
                  }
                }
              });
              rollerIndex++;
            });
          },
          constructRollers:function(numRollers){
            for(var k=0;k<numRollers;k++){
              var $roller = this.constructRoller();        
              this.rollers[k] = $roller;
              var lastPosition = false;
              $roller.css({
                left:k*22
              });
              $('#roller').append($roller);
            }
          },
          constructRoller:function(){
              var symbolHeight = 63;
              var $roller = $('<div />');
              $roller.data('symbols', symbols);
              $roller.data('rollTo', $.proxy(function(symbol,callback){
                var $this = $(this);                
                var targetSymbolIndex = $this.data('symbols').indexOf(symbol);
                var duration = Math.random()*2500+1500;
                var rolls = Math.round(duration/120);
                var totalAnimation = (symbols.length*rolls+targetSymbolIndex)*symbolHeight;
                $($this.data('animationObject')).animate({
                  t:-totalAnimation
                },{
                  easing:"easeInOutQuint",
                  duration:duration,
                  complete:function(){
                    this.t=this.lastPosition%(symbols.length*symbolHeight);
                    this.lastPosition = this.t;
                    if(typeof callback == 'function'){
                      callback();
                    }
                  },
                  step:function(now){
                    var topOffset = Math.floor(now%(symbols.length*symbolHeight));
                    var $container = this.roller.find('.symbols-container');
                    
                    $container.css({
                      top:topOffset
                    });
                    if(this.lastPosition){
                      // calculate speed
                      var speed = Math.abs(this.lastPosition-now);
                      
                      $container.find('*').hide();
                      if(speed<5){
                        $container.find('.sharp').show();
                      }
                      if(speed>=5 && speed <15){
                        $container.find('.blur').show();
                      }
                      if(speed>=8){
                        $container.find('.blurrier').show();
                      }
                    }
                    this.lastPosition = now;
                  }
                });
              },$roller));
              $roller.addClass('symbols-roller');
              var animationObject = {t:0, roller:$roller};
              $roller.data('animationObject',animationObject);
              var $symbolWrapper = $('<div />');
              $symbolWrapper.addClass('symbols-container');
              $symbolWrapper.css({
                width:21,
                height:symbols.length*symbolHeight
              });
              var wrappers = {};
              
              $.each(['sharp','blur','blurrier'],function(){
                var $typeWrapper = $('<div />');
                $typeWrapper.css({
                  position:'absolute',
                  top:0,
                  left:0
                });
                var blur = String(this);
                $typeWrapper.addClass(blur);
                for(var k=0;k<symbols.length+1;k++){
                  var value = String(symbols[k%symbols.length]);
                  var $symbol = $('<div />').addClass('symbol');
                  $symbol.addClass(value);
                  $symbol.addClass(blur);
                  $typeWrapper.append($symbol);
                };
                wrappers[this] = $typeWrapper;
                $symbolWrapper.append($typeWrapper);
              });
              $symbolWrapper.data('wrapper', wrappers);
              $roller.append($symbolWrapper);
              return $roller;
            },
            checkWinningCondition:function(){
              if(this.gameState.goodAnwsers == 5){
                // you won!
                this.gameWon();
              }
              if(this.gameState.badAnwsers == 3){
                // you lost!
                this.gameLost();
              }
            },
            getNewFormula:function(){
              // roll set
              this.playSound('roll');
              // sum formulas
              var set = 3;
              // randomize set
              if(Math.random() > 0.5){
                set = 4;
              }
              if(DEBUG_MODE){
                set = 4;
              }
              this.gameState.setsSet = set;
              this.canRoll = false;
              var formulas = this.gameState.sets[set].formulas;              
              var formulaIndex = Math.floor(Math.random()*formulas.length);
              
              if(DEBUG_MODE){
                var formulaIndex = 0;
              }
              var newFormula = formulas.splice(formulaIndex,1)[0];
              this.rollFormula(newFormula);
              
            },

            playSound:function(soundId){
              if(this.gameOptions.sound){
                this.sounds[soundId].currentTime = 0;
                this.sounds[soundId].play();
              }
            },
            gameWon:function(){
                this.ui.killPopups();
                this.playSound('win');
                var $titledContainer = this.ui.titledContainer('Gratulacje! Zwyciężyłeś!');
                $titledContainer.attr('id','won-box');
                var percentScore = 100-this.gameState.badAnwsers*25;
                var totalPoints = Math.round((percentScore/100)*this.maxScore);
                this.gameState.score.points = totalPoints;
                this.gameState.score.percent = percentScore;
                // add some score info
                var scoreContainer = $('<div />').addClass('score');
                var scoreContent = [
                  'Zdobyte punkty: '+percentScore+'% - '+totalPoints+' pkt.',
                ].join('<br />');
                scoreContainer.html(scoreContent);                
                
                $titledContainer.append($('<div />').addClass('cup'));
                $titledContainer.append(scoreContainer);
                var $app = this;
                this.ui.popupWindow($titledContainer,function(){
                    $app.restartGame();
                });
                this.postScore();
            },
            gameLost:function(){
                this.playSound('lost');
                this.ui.killPopups();
                var $titledContainer = this.ui.titledContainer('Tym razem nie udało się! Spróbuj ponownie!');
                $titledContainer.attr('id','lost-box');
                $titledContainer.append($('<p />').html('Niestety zbiory nie są jeszcze Twoją mocną stroną ale nie zrażaj się - spróbuj jeszcze raz.'));
                var $app = this;
                this.ui.popupWindow($titledContainer,function(){
                    $app.restartGame();
                });
            },
            gameOptions:{
              sound:1
            },
            gameState:{
                score:{
                  percent:0,
                  points:0
                }
            },
           
            container:null,
            statusBox:null,
            progressBox:null,
            updateStatus:function(){
              var greenLeds = $('.led.green');
              var redLeds = $('.led.red');
              var $led = false;
              if(this.gameState.goodAnwsers >  greenLeds.length){
                // add green led
                $led = $('<div />').addClass('led green');
                var topOffset = 165+greenLeds.length*28;
                var leftOffset = 667;
              }
              if(this.gameState.badAnwsers >  redLeds.length){
                $led = $('<div />').addClass('led red');
                var topOffset = 187+(redLeds.length)*28;
                var leftOffset = 256;
              } 
              if($led){
                $('#front-layer').append($led);
                $led.css({
                  top:topOffset,
                  left:leftOffset,
                  opacity:0
                });
                $led.animate({
                  opacity:1
                }, {
                  easing:'easeInBounce'
                });
              }
            },

            postScore:function(){
                var score = this.gameState.score;
                this.api.saveResult(score.points, score.percent);
            },
            
            restartGame:function(){
              var $app = this;
              $app.clearSets();
              $app.rollToEmpty();
              this.ui.killPopups();
              // kill leds
              $('.led').each(function(){
                $(this).delay(Math.random()*800).fadeOut(Math.random()*800+200, function(){
                  $(this).remove();
                });
              });
              this.gameState.sets = JSON.parse(JSON.stringify(this.sets));
              this.gameState.goodAnwsers=0;
              this.gameState.badAnwsers=0;
            },
            sounds:[],
            initSound:function(){
                this.sounds['click'] = new Audio('sound/button_50.ogg');
                this.sounds['click2'] = new Audio('sound/button_30.ogg');
                this.sounds['win'] = new Audio('sound/win.ogg');
                this.sounds['roll'] = new Audio('sound/kching.ogg');
                this.sounds['lost'] = new Audio('sound/lost.ogg');
                this.sounds['led'] = new Audio('sound/lampka.ogg');
                this.sounds['bad'] = new Audio('sound/bad.ogg');
                this.sounds['ding'] = new Audio('sound/ding.ogg');
            },
            
            onCorrectAnwser:function(){
              this.gameState.goodAnwsers++;
              this.playSound('ding');
            },
            onFailedAnwser:function(){
              this.gameState.badAnwsers++;
              this.playSound('bad');
            },

            checkAnwser:function(anwser){
            var $app = this;
              if(!$app.canAnwser){
                return;
              }
              
              if(anwser == $app.gameState.showGood){
                $app.onCorrectAnwser();
              } else {
                $app.onFailedAnwser();
              }
              $app.canAnwser = false;
              $app.canRoll = true;
              $app.updateStatus();
              $app.checkWinningCondition();
            },
            init:function(container){
                this.initSound();
                this.ui = new UIHelper();
                this.ui.app = this;
                this.api = new APIHelper();
                this.ui.container = this.container = container;
                this.buildMenu();
                var $app = this;
                $app.canAnwser = false;
                $app.constructRollers(11);
                $app.gameState.goodAnwsers=0;
                $app.gameState.badAnwsers=0;
                $app.gameState.sets = JSON.parse(JSON.stringify($app.sets));
                // init OK/X
                $('.game-button').on('mousedown', function(){
                  $(this).addClass('active');
                  $app.playSound('click');
                });
                $('.game-button').on('mouseup mouseout', function(){
                  $(this).removeClass('active');
                });
                $('.game-button.ok').on('mouseup', function(){
                  $app.checkAnwser(true);
                });
                $('.game-button.x').on('mouseup', function(){
                  $app.checkAnwser(false);
                });

                $app.canRoll = true;
                $('#handle').on('click', function(){

                    // animate the handle
                    var $handle = $(this);
                    setTimeout(function(){                    
                      $handle.css({
                        backgroundPosition:'-92px 0px'
                      });
                      
                      setTimeout(function(){                    
                        $handle.css({
                          backgroundPosition:'-184px 0px'
                        });
                        if($app.canRoll){
                          $app.getNewFormula();
                        } else {
                          $app.playSound('click2');
                        }
                        setTimeout(function(){                    
                          $handle.css({
                            backgroundPosition:'-92px 0px'
                          });
                          setTimeout(function(){                    
                            $handle.css({
                              backgroundPosition:'0px 0px'
                            });
                          },100);
                        },100);
                      },100);
                    },100);           

                });
            },
            showHighscore:function(){
                var $titledContainer = this.ui.titledContainer('Najlepsi z najlepszych');
                $titledContainer.attr('id','highscore-box');
                // construct hiscore table
                var $scoreTable = $('<table />').addClass('highscores');
                var $scoreTableHeader = $('<tr />').append('<th class=\'nick\'>Nick</th><th class=\'score\'>Wynik</th><th class=\'score\'>Wynik (%)</th>');
                $scoreTable.append($scoreTableHeader);
                var $app = this;
                this.api.getHighscores(function(r){
                    if(r){
                      var results = $(r).find('UserScore');
                      if(results.length){
                          $.each(results, function(){
                              var $scoreRow = $('<tr />');
                              var nick = this.getElementsByTagName('Nick')[0].childNodes[0].nodeValue;
                              var score = this.getElementsByTagName('Result')[0].childNodes[0].nodeValue;
                              var scorePercent = this.getElementsByTagName('ResultPercent')[0].childNodes[0].nodeValue;
                              $scoreRow.append('<td>'+nick+'</td><td>'+score+'</td><td>'+scorePercent+'</td>');
                              $scoreTable.append($scoreRow);
                          });
                      }
                    } else {
                      $scoreRow = $('<tr />').append($('<td>Nie udało się pobrać wyników.</td>').attr({
                        colspan:3,
                        align:'center'
                      }));
                      $scoreTable.append($scoreRow);
                    }
                    $app.ui.popupWindow($titledContainer,function(){});
                });
                
                
                $titledContainer.append($scoreTable);
                // TODO refactor
                // create menu items object in app
                
            },
            showCredits:function(){
                var $titledContainer = this.ui.titledContainer('Twórcy gry');
                $titledContainer.attr('id','credits-box');
                $titledContainer.append($('#app-credits').html());
                // TODO refactor
                // create menu items object in app
                this.ui.popupWindow($titledContainer,true);
            },            
            showHelp:function(){
                var $titledContainer = this.ui.titledContainer('Zasady gry');
                $titledContainer.attr('id','help-box');
                $titledContainer.append($('#app-help').html());
                // TODO refactor
                // create menu items object in app
                this.ui.popupWindow($titledContainer,true);
            },            
            buildMenu:function(){
                
                var $menuContainer = $('<div />').addClass('menu-container');
                var menuItems = [
                    {
                        label:'Pomoc',
                        onClick:$.proxy(this.showHelp,this),
                        css:'help'
                    },
                    {
                        label:'Najlepsi',
                        onClick:$.proxy(this.showHighscore,this),
                        css:'highscore'
                        
                    },
                    {
                        label:'Twórcy',
                        onClick:$.proxy(this.showCredits, this),                        
                        css:'credits'
                    },
                    {
                        label:'Restart',
                        onClick:$.proxy(this.restartGame,this),
                        css:'restart'
                    }
                ]
                var $app = this;
                $.each(menuItems, function(){
                    var $menuButton = $app.ui.buildButton(this.label, this.onClick, 'click');
                    if(this.css){
                      $menuButton.addClass(this.css);
                    }
                    $menuContainer.append($menuButton);
                });
                this.container.append($menuContainer);
//                this.container.append(this.ui.buildButton("Twórcy", $.proxy(this.showCredits, this), 'click').addClass('small credits'));
            }
            
        }
    }

    $(document).on('ready', function(){
      
      var rollers = [];
      
        app = new App();

        app.init($('#app-container #front-layer'));
    });
}(jQuery,CryptoJS));
/**
if(DEBUG_MODE){
  var $edit = $('<div />');
  $edit.css({ 
    background:'#fff',
    width:290,
    height:210,
    top:0,
    left:0,
    position:'absolute'
    
  });
  var $output = $('<div />').css({
    background:'#fff',
    width:290,
    height:210,
    top:210,
    left:0,
    position:'absolute'
  });
  $('body').append($output);
  $('body').append($edit);
  $.each($app.sets[4].parts, function(){
    var $i = $('<img />').attr({
      src:'img/sets/'+this+'.png'
    });
    $i.data('e', this);
    var $cb = $('<input />').attr('type','checkbox');
    $cb.attr('name', 'cb-'+this);
    var $l = $('<label />').html(this).attr('for', 'cb-'+this);
    
    $output.append($cb);
    $output.append($l);
    $cb.data('i', $i);
    $i.css({
      opacity:0.2,
      position:'absolute'
    });
    $cb.on('click', function(){
      var $i = $(this).data('i');
      if($(this).prop('checked')){
        $i.addClass('show');
        $i.css('opacity',1);
      } else {
        $i.removeClass('show');
        $i.css('opacity',0.2);
      }
      var names = [];
      $('.show').each(function(){
        names.push("'"+$(this).data('e')+"'");
      });
      
      console.log('['+names.join(',')+']');
    });
    $edit.append($i);
  });
                          var $i = $('<img />').attr({
      src:'img/sets/'+'4_ov'+'.png'
    });
    $i.css({
      position:'absolute'
    });
    $edit.append($i);
}
**/