$(function() {
    var menu = $('#menu');
    var menuItems = menu.find('a');
    var pagesContainer = $('#pages');
    var pages = pagesContainer.children('div');
    var questionElement = $('#question');
    var checkElement = $('#check');
    var validatorElement = $('#validator');
    var containerElement = $('#container');
    var gameElement = $('#nowa-gra');
    var progressCurrent = $('#progress-current');
    var progressTotal = $('#progress-total');
    var tryElement = $('#try');
    var playaudio = (function() {
        var click = new Audio('audio/click.wav');
        var wrong = new Audio('audio/wrong.wav');
        var good = new Audio('audio/good.wav');
        var play = function(audio) {
            audio.pause();
            audio.currentTime = 0;
            audio.play();
        };
        return {
            click: function() {
                play(click);
            },
            wrong: function() {
                play(wrong);
            },
            good: function() {
                play(good);
            }
        };
    })();
    pages.hide();
    var popup = {
        container: containerElement,
        elements: [],
        killPopups: function() {
            while (this.elements.length) {
                var $element = this.elements.pop();
                $element.remove();
            }
        },
        popupWindow: function(content, onClose) {
            // append overlay
            var $overlay = $('<div />').css({
                opacity: 0.5,
                background: '#000',
                width: 800,
                height: 600,
                position: 'absolute',
                left: 0,
                top: 0
            });
            content = $('<div />').html(content);
            content.css({
                position: 'absolute'
            });
            this.container.append($overlay);
            this.container.append(content);
            this.container.width();
            content.addClass('popup-window');
            content.css({
                left: (this.container.width() - content.outerWidth()) / 2,
                top: (this.container.height() - content.outerHeight()) / 2
            });

            if (onClose) {
                var $ui = this;

                var $closeButton = $('<div></div>').addClass('close-button').text('X');
                $closeButton.on('click', function() {
                    $ui.killPopups();
                    playaudio.click();
                    if (typeof onClose === 'function') {
                        onClose();
                    }
                });
                content.append($closeButton);
            }
            this.elements.push($overlay, content);
        }
    };

    var APIHelper = function() {
        var apiURL = '/CommunicationService.svc';
        var sessionIdRegexResult = location.search.match(/[\d\w]{8}-[\d\w]{4}-[\d\w]{4}-[\d\w]{4}-[\d\w]{12}/);
        var sessionId = null;
        if (sessionIdRegexResult) {
            sessionId = sessionIdRegexResult[0];
        }
        return {
            saveResult: function(percent, callback, error) {
                if (!sessionId) {
                  console.log('brak identyfikatora sesji');
                   return false;
                }
                var result = 0;
                var data = [apiURL, 'saveresult', sessionId, result, percent];
                var hash = CryptoJS.MD5(sessionId + result + percent).toString();
                var ajaxURL = data.join('/');
                $.ajax({
                    url: ajaxURL + '?hash=' + hash,
                    success: callback,
                    error: error,
                    dataType: 'xml',
                    cache: false
                });
            },
            getHighscores: function(callback, error) {
                if (!sessionId) {
                    // offline mode. skip and send false to callback function
                    callback(false);
                    return false;
                }
                var params = [apiURL, 'gettopscores', sessionId];
                var ajaxURL = params.join('/');
                $.ajax({
                    url: ajaxURL,
                    success: callback,
                    error: error,
                    dataType: 'xml',
                    cache: false
                });
            }
        };
    };
    var APIHelperInstance = new APIHelper();
    var showPopup = function(element) {
        var href = $(element).attr('href'),
                pageContent = $(href);
        if (pageContent.hasClass('popup')) {
            var content = pageContent.clone();
            switch (href) {
                case '#najlepsi':
                    var status = content.find('#top-players-status').text('Trwa wczytywanie danych...');
                    APIHelperInstance.getHighscores(function(data) {
                        var topPlayers = content.find('#top-players');
                        var list = '';
                        $.each($(data).find('UserScore'), function(key, value) {
                            var $value = $(value);
                            list += '<li>' + $value.find('Nick').text() + ', wynik: ' + $value.find('Result').text() + '</li>';
                        });
                        if (list === '') {
                            status.text('Brak wyników');
                        } else {
                            topPlayers.html(list);
                            status.text('');
                        }
                    }, function() {
                        status.text('Wystąpił błąd');
                    });
                    break;
            }
            popup.popupWindow(content.show(), true);
        } else {
            switch (href) {
                case '#nowa-gra':
                case '#restart':
                    initGameValues();
                    break;
            }
        }
    };
    menuItems.click(function(e) {
        e.preventDefault();
        showPopup(this);
        playaudio.click();
    });
    showPopup(menuItems.first());
    gameElement.show();

    var set = function() {
        return {
            A: false,
            B: false,
            C: false,
            AB: false,
            BC: false,
            CA: false,
            ABC: false,
            setValues: function(values) {
                for (var i = 0; i < values.length; i++) {
                    if (this.hasOwnProperty(values[i])) {
                        this[values[i]] = true;
                    }
                }
            }
        };
    };

    var circles = function() {
        this.set = new set();
        this.clicks = 0;
        this.draw = function() {
            var self = this;
            var shared1 = {
                path: 'img/01.png',
                imageobject: null
            }, shared2 = {
                path: 'img/02.png',
                imageobject: null
            }, shared3 = {
                path: 'img/03.png',
                imageobject: null
            }, stage = new Kinetic.Stage({
                container: 'game',
                width: 260,
                height: 250
            }), layer = new Kinetic.Layer(),
                    imageLoader = function(callback, imgs) {
                        var loadCount = 0,
                                i = 0,
                                load = function() {
                                    loadCount++;
                                    if (loadCount === imgs.length) {
                                        callback();
                                    }
                                };
                        for (; i < imgs.length; i++) {
                            var imageobject = new Image();
                            imageobject.onload = load;
                            imageobject.src = imgs[i].path;
                            imgs[i].imageobject = imageobject;
                        }
                    }, imgs = [shared1, shared2, shared3],
                    createImage = function(name, image, x, y, rotate) {
                        var img = new Kinetic.Image({
                            x: x,
                            y: y,
                            image: image.imageobject,
                            opacity: 0
                        });
                        img.rotateDeg(rotate);
                        applyEvents(name, img);
                        return img;
                    }, opacityStep = 0.5,
                    applyEvents = function(name, image) {
                        var currentOpacity = image.getOpacity();
                        image.on('mouseover', function() {
                            var opacity = currentOpacity > 0 ? opacityStep * 2 : opacityStep;
                            this.setOpacity(opacity);
                            layer.draw();
                        }).on('mouseout', function() {
                            this.setOpacity(currentOpacity);
                            layer.draw();
                        }).on('click', function() {
                            var opacity = currentOpacity > 0 ? 0 : opacityStep * 2;
                            this.setOpacity(opacity);
                            currentOpacity = opacity;
                            layer.draw();
                            playaudio.click();
                            self.clicks++;
                            self.set[name] = currentOpacity > 0;
                        });
                        image.createImageHitRegion(function() {
                            layer.draw();
                        });
                    };

            imageLoader(function() {
                var a = createImage('A', shared1, 4, 3, 0),
                        b = createImage('B', shared1, 284, 47, 120),
                        c = createImage('C', shared1, 106, 268, -120),
                        ab = createImage('AB', shared2, 112, 26, 0),
                        bc = createImage('BC', shared2, 210, 129, 120),
                        ca = createImage('CA', shared2, 72, 163, -120),
                        abc = createImage('ABC', shared3, 116, 95, 0);

                layer.add(a);
                layer.add(b);
                layer.add(c);
                layer.add(ab);
                layer.add(bc);
                layer.add(ca);
                layer.add(abc);

                stage.add(layer);
            }, imgs);
        };
    };

    var compareSet = function(set1, set2) {
        for (var set in set1) {
            if (set1.hasOwnProperty(set) && typeof set1[set] !== 'function') {
                if (set1[set] !== set2[set]) {
                    return false;
                }
            }
        }
        return true;
    };

    var avaliableTry;

    var game = function(sets, question) {
        var gameSet = new set;

        var board = new circles();
        board.draw();
        gameSet.setValues(sets);
        questionElement.html(question);
        
        if(question.length>30)questionElement.addClass('long');
          else questionElement.removeClass('long');
        
        this.getCircles = function() {
            return board;
        };
        this.getAvaliableTry = function() {
            return avaliableTry;
        };
        this.isValid = function() {
            var result = compareSet(gameSet, board.set);

            if (!result) {
                avaliableTry--;
            } else {
                if (sets.length < this.getCircles().clicks) {
                    var failClicks = this.getCircles().clicks - sets.length;
                    currentPoints.minus(failClicks * 2);
                }
            }
            return result;
        };
    };

    var points = function() {
        var currentPoints = 100;
        return {
            minus: function(value) {
                if (value <= currentPoints) {
                    currentPoints -= value;
                } else {
                    currentPoints = 0;
                }
            },
            getPoints: function() {
                return currentPoints;
            }
        };
    };
    var gamesBackup = function() {
        return [
            [
                {sets: ['A', 'B', 'AB', 'CA', 'ABC'], question: 'A&#8899;(B&#8726;C)'},
                {sets: ['ABC'], question: 'A&#8898;B&#8898;C'},
                {sets: ['A'], question: 'A&#8726;(B&#8899;C)'},
                {sets: ['AB', 'CA', 'ABC'], question: 'A&#8898;(B&#8899;C)'}
            ],
            [
                {sets: ['AB'], question: 'A&#8898;(B&#8726;C)'},
                {sets: ['AB'], question: '(A&#8898;B)&#8726;C'},
                {sets: ['A', 'B', 'AB', 'CA'], question: '(A&#8899;B)&#8726;(A&#8898;C)'},
                {sets: ['C'], question: '(C&#8726;A)&#8726;B'},
                {sets: ['B', 'C', 'BC'], question: '(C&#8726;A)&#8899;(B&#8726;A)'}
            ],
            [
                {sets: ['A', 'AB', 'CA'], question: 'A&#8726;(B&#8898;C)'},
                {sets: ['CA'], question: '(C&#8898;A)&#8726;B'},
                {sets: ['B', 'C', 'BC'], question: '(B&#8899;C)&#8726;A'},
                {sets: ['A'], question: '(A&#8726;B)&#8898;(A&#8726;C)'}
            ],
            [
                {sets: ['AB'], question: '(A&#8726;C)&#8898;(B&#8726;C)'},
                {sets: ['B', 'C', 'BC'], question: '(C&#8726;A)&#8899;(B&#8726;A)'},
                {sets: ['A', 'B', 'C', 'AB', 'BC', 'CA'], question: '(A&#8899;B&#8899;C)&#8726;(A&#8898;B&#8898;C)'},
                {sets: ['A', 'AB', 'CA', 'BC', 'ABC'], question: '(A&#8899;B)&#8898;(A&#8899;C)'},
                {sets: ['AB', 'CA', 'ABC'], question: '(A&#8898;B)&#8899;(A&#8898;C)'}
            ],
            [
                {sets: ['A', 'AB', 'CA'], question: '(A&#8726;B)&#8899;(A&#8726;C)'},
                {sets: ['CA'], question: '(A&#8726;B)&#8898;(C&#8726;B)'},
                {sets: ['AB', 'BC', 'CA', 'ABC'], question: '(A&#8898;B)&#8899;(B&#8898;C)&#8899;(C&#8898;A)'},
                {sets: ['AB', 'CA'], question: '[(A&#8898;B)&#8899;(A&#8898;C)]&#8726;(B&#8898;C)'}
            ]
        ];
    };

    var getGame = function() {
        if (games[gameCurrent].length === 0) {
            games = gamesBackup();
        }
        var currentGameGroup = games[gameCurrent];
        var index = Math.floor(Math.random() * currentGameGroup.length);
        
        var currentGame = currentGameGroup[index];

        if (typeof currentGame !== 'undefined') {
            currentGameGroup.splice(index, 1);
            progressCurrent.text(gameCurrent + 1);
            progressTotal.text(games.length);
            return new game(currentGame.sets, currentGame.question);
        }
    };

    var initGameValues = function() {
        avaliableTry = 3;
        currentPoints = new points();
        games = gamesBackup();
        gameCurrent = 0;
        currentGame = getGame();
    };
    var currentPoints;
    var games;
    var gameCurrent;
    var currentGame;
    initGameValues();

    var sendData = function(points) {
        APIHelperInstance.saveResult(points, function() {
            popup.popupWindow('<p>Koniec. Twój wynik to ' + points + '%. Wynik przesłano do serwera.</p>', true);
        }, function() {
            popup.popupWindow('<p>Koniec. Twój wynik to ' + points + '%. Błąd przy przesyłaniu danych do serwera.</p>', true);
        });
    };

    checkElement.click(function() {
        if (currentGame.isValid()) {
            validatorElement.addClass('on');
            setTimeout(function() {
                validatorElement.removeClass('on');
            }, 3000);
            playaudio.good();
            gameCurrent++;
            if (gameCurrent === games.length) {
                sendData(currentPoints.getPoints());
                initGameValues();
            } else {
                currentGame = getGame();
            }
        } else {
            if (currentGame.getAvaliableTry() === 0) {
                initGameValues();
                sendData(0);
                tryElement.html('');
            } else {
                tryElement.append($('<span />'));
            }
            playaudio.wrong();
        }
    });
});
