

(function($,CryptoJS){
    if(!Array.prototype.last){
      // boost Array prototype with last()
      Array.prototype.last = function(){
        return this[this.length-1];
      }
    }
    var DEBUG_MODE = false;
    // temporary debugging proxy
    // local
    // var apiURL = 'proxy.php?url=CommunicationService.svc';
    var apiURL = 'http://gra.archipelagmatematyki.pl/CommunicationService.svc';
    var sessionIdRegexResult = location.search.match(/[\d\w]{8}-[\d\w]{4}-[\d\w]{4}-[\d\w]{4}-[\d\w]{12}/);
    var sessionId = null;
    if(sessionIdRegexResult){
      sessionId = sessionIdRegexResult[0];
    }
    if(location.search.match(/debug/)){
      DEBUG_MODE = true;
    }
    var APIHelper = function(){
        return {
            saveResult:function(score, percent, callback){
                if(!sessionId) {
                  // offline mode. abandon ship!
                  return false;
                }
                var hash = CryptoJS.MD5(sessionId+score+percent).toString();
                var ajaxURL = [apiURL,'saveresult', sessionId, score,percent].join('/');
                $.ajax({
                    
                    url:ajaxURL+'?hash='+hash,
                    success:callback
                });
            },
            getHighscores:function(callback){
                if(!sessionId) {
                  // offline mode. abandon ship! (and send false hope to callback function)
                  callback(false);
                  return false;
                }
                var ajaxURL = [apiURL,'gettopscores', sessionId].join('/');
                $.ajax({
                    url:ajaxURL,
                    success:callback
                });
            }            
        }
    }
    var UIHelper = function(){
        return {
            elements:[],
            app:{},
            backgroundColors:[
              '#fffcb7',
              '#ffffff',
              //'#ff3c3c',
              '#60ed93',
              '#c2e0f5',
              '#ecc5f1'
            ],
            createColorSelector:function(){
              var $ui = this;
              $.each(this.backgroundColors, function(i){
                var $innerDot = $('<div />').addClass('dot');
                var $outerDot = $('<div />').addClass('outer-dot').append($innerDot);
                if(i==0){
                  $outerDot.addClass('first');
                }
                if(i==$ui.backgroundColors.length-1){
                  $outerDot.addClass('last');
                }
                $innerDot.css({
                  background:this
                });
                $outerDot.on('click', function(){
                  $('#color-back-layer').css({
                    backgroundColor:$(this).find('.dot').css('backgroundColor')
                  });
                });
                $('#color-selector').append($outerDot);
              })
            },
            buildButton:function(label, onClick,audioId){
                var $button = $('<button />').attr({
                    type:'button'
                });
                $button.addClass('ui-button');
                $button.html(label);
                $button.data('onClick',$.proxy(onClick,$button));
                var $app = this.app;
                if(audioId !== undefined){
                    $button.on('click',function(){
                        $(this).data('onClick')();
                        $app.playSound(audioId);
                    });
                } else {
                    $button.on('click',onClick);
                }
                
                return $button;
            },
            titledContainer:function(title){
                var $container = $('<div />').addClass('ui-container ui-window');
                var $title = $('<h1 />').html(title);
                var $content = $('<div />').addClass('ui-content');
                $container.append($title, $content);
                return $container;
            },
            killPopups:function(){
                while(this.elements.length){
                    var $element = this.elements.pop();
                    $element.remove();
                }
                
            },
            popupWindow:function(content,onClose){
                // append overlay
                var $overlay = $('<div />').css({
                    opacity:0.5,
                    background:'#000',
                    width:800,
                    height:600,
                    position:'absolute',
                    left:0,
                    top:0,
                    zIndex:500
                });
                content.css({
                    position:'absolute',
                    zIndex:501
                });
                this.container.append($overlay);
                this.container.append(content);
                this.container.width();
                content.addClass('popup-window');
                content.css({
                    left:(this.container.width()-content.outerWidth())/2,
                    top:(this.container.height()-content.outerHeight())/2,
                });
                
                if(onClose){
                    var $ui = this;
                    
                    var $closeButton = $('<div></div>').addClass('close-button');
                    $closeButton.on('click', function(){
                        
                        app.playSound('click2');
                        $ui.killPopups();
                        if(typeof onClose == 'function'){
                          onClose();
                        }
                    });
                    content.append($closeButton);
                }
                this.elements.push($overlay,content);
            }
        }
    }
    var App = function(){
        return {
            maxScore:20,
            penalty:5,
            timePenalty:3,
            levels:{
                1:{
                    label:'Etap 1',
                    maxMoves:4,
                    maxTime:4.000,
                    score:22,
                    items:5,
                    order:[3,1,4,5,2]
                },
                2:{
                    label:'Etap 2',
                    maxMoves:4,
                    maxTime:8.000,
                    score:33,
                    items:6,
                    order:[2,3,4,1,6,5]
                },
                3:{
                    label:'Etap 3',
                    maxTime:10.000,
                    maxMoves:4,
                    score:45,
                    items:7,
                    order:[4,5,1,3,7,6,2]
                },                
            },
            elements:$.parseJSON('{"1":{"file":"img\/s01.png","size":[120,121]},"2":{"file":"img\/s02.png","size":[101,102]},"3":{"file":"img\/s03.png","size":[81,82]},"4":{"file":"img\/s04.png","size":[67,67]},"5":{"file":"img\/s05.png","size":[57,58]},"6":{"file":"img\/s06.png","size":[48,48]},"7":{"file":"img\/s07.png","size":[36,36]}}'),
            currentSettings:{},
            progressSessionVariableName:'gamestate-'+sessionId,
            loadSession:function(){
              if(sessionId){
                sessionData = $.cookie(this.progressSessionVariableName);
                if(sessionData){
                  this.gameProgress = $.parseJSON(sessionData);
                }
              }
            },
            checkWinningCondition:function(){
              var lastIndex = 0;
              var inOrder = true;
              $.each(this.gameState.currentOrder, function(){
                if(!inOrder){
                  return;
                }
                var currentIndex = $(this).data('index');
                if(currentIndex<lastIndex){
                  inOrder=false;
                } else {
                  lastIndex = currentIndex;
                }
              });
              if(inOrder){
                this.levelComplete();
              }
                //this.updateStatus();
                
            },
            levelComplete:function(){
              clearInterval(this.gameState.timerInterval);
              var level = this.currentSettings.currentLevel;
              this.gameState.levelComplete = true;
              var partsList = [];
              var $app = this;
              var maxMoves = $app.currentSettings.currentLevel.maxMoves;
              var playerMoves = $app.gameState.moves;
              var penalty = 0;
              var timePenalty = 0;
              var maxTime = $app.currentSettings.currentLevel.maxTime;
              var playerTime = $app.gameState.timePassed;
              if(playerTime > maxTime){
                timePenalty = Math.ceil((playerTime-maxTime)*this.timePenalty);
              }
              if(playerMoves > maxMoves){
                penalty = (playerMoves-maxMoves)*$app.penalty;
              }
              var levelScore = Math.max(0,$app.currentSettings.currentLevel.score-penalty-timePenalty);
              $app.gameState.score.percent += levelScore;
              var levelScoreText = 'Zdobyte punkty za etap: '+levelScore+'%';
              if(penalty != 0){
                levelScoreText += '<br/>(-'+penalty+'% za niepotrzebne ruchy)';
                
              }
              if(timePenalty != 0){
                levelScoreText += '<br/>(-'+timePenalty+'% za przekroczony czas)';
              }
              var $titledContainer = this.ui.titledContainer('Etap zakończony!');
              // construct hiscore table
              var $description = $('<div />').append([
                'Udało ci się prawidłowo ułożyć skrzynie!',
                '',
                'Liczba ruchów: '+this.gameState.moves,
                levelScoreText,
                'Punktów w sumie: '+$app.gameState.score.percent+' %'
              ].join('<br />'));
              $titledContainer.find('.ui-content').append($description);
              this.playSound('level_win');
              this.ui.popupWindow($titledContainer,function(){
                // get next level and start
                var skipLoop = false;
                $.each($app.levels, function(i){
                  if(skipLoop){
                    return;
                  }
                  if(this == $app.currentSettings.currentLevel){
                    skipLoop = true;
                    if(i<Object.keys($app.levels).length){
                      
                      // we've got next level!
                      // carry on
                      $app.currentSettings.currentLevel = $app.levels[parseInt(i)+1];
                      $app.startLevel();
                      
                    } else {
                      // game finished!
                      $app.gameWon();
                    }
                  }
                });
              });
            },
            playSound:function(soundId){
              if(this.gameOptions.sound){
                this.sounds[soundId].currentTime=0;
                this.sounds[soundId].play();
              }
            },
            gameWon:function(){
                this.ui.killPopups();
                this.playSound('win');
                
                var $titledContainer = this.ui.titledContainer('Gratulacje! Zwyciężyłeś!');
                $titledContainer.attr('id','won-box');
                var percentScore = this.gameState.score.percent;
                var totalPoints = Math.round((percentScore/100)*this.maxScore);
                this.gameState.score.points = totalPoints;
                // add some score info
                var scoreContainer = $('<div />').addClass('score');
                var scoreContent = [
                  'Zdobyte punkty: '+percentScore+'%',
                ].join('<br />');
                scoreContainer.html(scoreContent);                
                
                $titledContainer.append($('<div />').addClass('cup'));
                $titledContainer.append(scoreContainer);
                var $app = this;
                this.ui.popupWindow($titledContainer,function(){
                    $app.newGame();
                });
                //this.updateProgress();
                this.postScore();
            },
            gameOptions:{
              sound:1
            },
            gameState:{
                moves:0,
                boardLength:0,
                hasValidCuts:false,
                levelStarted:false,
                partsBin:{},
                completeObjects:0,
                activePart:false,
                waste:0,
                score:{
                  percent:0,
                  points:0
                }
            },
           
            container:null,
            statusBox:null,
            progressBox:null,
            updateStatus:function(){
              var now = new Date().getTime();
              if(!this.gameState.startTime){
                this.gameState.startTime = now;
              }

              // var timePassed = (now-this.gameState.startTime)/1000;
              // this.gameState.timePassed = timePassed;
              // // format time
              // $('#status-box .timer').html(timePassed.toFixed(3)+' s'+' / '+this.currentSettings.currentLevel.maxTime.toFixed(3)+' s');
              // $('#status-box .moves').html('Ruchy: '+this.gameState.moves+'/'+this.currentSettings.currentLevel.maxMoves);
              $('#status-box .player-moves').html('Twoje ruchy: '+this.gameState.moves);
              $('#status-box .game-moves').html('Minimalna liczba ruchów: '+this.currentSettings.currentLevel.maxMoves);
              
            },
            showNewLevelInfo:function(){
              var $app = this;
              if(DEBUG_MODE){
                // skip on debug
                $app.gameState.startTime = new Date().getTime();
                $app.updateStatus();
                // $app.gameState.timerInterval = setInterval($.proxy($app.updateStatus,$app),50);
                return;
              }
              var partsList = [];
              var level = this.currentSettings.currentLevel;
              var $titledContainer = this.ui.titledContainer(level.label);
              $titledContainer.attr('id','highscore-box');
              // construct hiscore table
              var $description = $('<div />').append([
                'W tym etapie musisz ustawić w poprawnej kolejności '+level.items+' skrzyń',
                '',
                'Minimalna liczba ruchów: '+level.maxMoves
              ].join('<br />'));
                $titledContainer.find('.ui-content').append($description);
              this.ui.popupWindow($titledContainer,function(){
                // $app.gameState.timerInterval = setInterval($.proxy($app.updateStatus,$app),50);
                $app.updateStatus();
                $app.gameState.startTime = new Date().getTime();
              });
            },
            postScore:function(){
                var score = this.gameState.score;
                this.api.saveResult(score.points, score.percent);
            },
            
            startLevel:function(){
              var $app = this;
              // remove items
              $('#elements-container *').remove();
              // init items
              this.initItems();
              if(this.gameState.timerInterval){
                clearInterval(this.gameState.timerInterval);
              }
              this.gameState.levelStarted = true;
              this.gameState.levelComplete = false;
              
              var level = this.currentSettings.currentLevel;
              // show info
              this.showNewLevelInfo();
              this.gameState.moves = 0;
            },
            setItemsTarget:function(){
              var currentX = 0;
              $.each(this.gameState.currentOrder, function(){
                $(this).data('targetX', currentX);
                currentX+=$(this).data('item').size[0];
              });
            },
            animateItems:function(onFinishedCallback){
              var completeItems = 0;
              var $app = this;
              $.each(this.gameState.currentOrder, function(){
                var $this = $(this);
                $this.animate({
                  left:$this.data('targetX'),
                  top:0
                },{
                  step:function(now){
                    $(this).data('mouseDiv').css({
                      left:now
                    });
                  },
                  complete:function(){
                    completeItems++;
                    if(completeItems == $app.gameState.currentOrder.length){
                      // all animated
                      // fire callback
                      if(typeof onFinishedCallback == 'function'){
                        onFinishedCallback();
                      }
                    }
                  }
                });
              });
            },
            setMarkerType:function(marker, markerType){
              marker.removeClass('up down');
              marker.addClass(markerType);
              var topOffset = marker.data('top');
              switch(markerType){
                case 'up':
                  topOffset -= 15;
                  break;
                case 'down':
                  topOffset += 30;
                  break;
              }
              marker.css({
                top:topOffset
              });
            },
            showMarkerOnItem:function(item){
              var currentOrder = this.gameState.currentOrder;
              if(item[0] == currentOrder[0]){
                return;
              }
              if(!this.gameState.markers.active){
                var $elementsContainer = $('#elements-container');
                var $markerDiv = $('<div />').addClass('marker');
                $elementsContainer.append($markerDiv);
                this.gameState.markers.active = $markerDiv;
              }
              var activeMarker = this.gameState.markers.active;
              activeMarker.css({
                left:$(item).find('img').position().left+$(item).find('img').width()-48
              });
              activeMarker.data('top', item.position().top);
              // define if hand is up or down
              // clear up/down classes
              var markerType;
              if(this.gameState.markers.set){
                var setMarker = this.gameState.markers.set;
                if(currentOrder.indexOf(setMarker.data('item')) < currentOrder.indexOf(item[0])){
                  this.setMarkerType(setMarker, 'up');
                  markerType = 'down';
                } else {
                  this.setMarkerType(setMarker, 'down');
                  markerType = 'up';
                }
              } else {
                if(item[0] == this.gameState.currentOrder.last()){
                  // is lowest
                  // set to down hand
                  markerType = 'down';
                } else {
                  markerType = 'up';
                }
              }
              this.setMarkerType(activeMarker, markerType);
            },
            shuffleItems:function(startItem,endItem){
              
              var $app = this;
              var currentOrder = this.gameState.currentOrder;
              // 
              var startItemIndex = currentOrder.indexOf(startItem[0]);
              var endItemIndex = currentOrder.indexOf(endItem[0]);
              if(startItemIndex == endItemIndex){
                // no shuffle
                return;
              }
              if(startItemIndex < endItemIndex){
                startIndex = startItemIndex;
                endIndex = endItemIndex;
              } else {
                startIndex = endItemIndex;
                endIndex = startItemIndex;
              }
              
              var newArray = [];

              
              var temp = currentOrder[startIndex];
              currentOrder[startIndex] = currentOrder[endIndex];
              currentOrder[endIndex] = temp;
              
              this.playSound('slide');
              this.gameState.moves++;
              this.updateStatus();
              this.setItemsTarget();
              $app.checkWinningCondition();
              this.animateItems();
              // remove markers
            },
            moveIndicatorUp:function(){
              this.animate({
                top:this.data('top')-5
              },{complete:$.proxy(this.data('app').moveIndicatorDown,this)});
            },
            moveIndicatorDown:function(){
              this.animate({
                top:this.data('top')+5
              },{complete:$.proxy(this.data('app').moveIndicatorUp,this)});
            },
            
            setActiveItem:function(item){
              if(!this.gameState.markers.active){
                this.gameState.markers.active = item[0];
                // attach indicator
                var $indicator = $('<div />').addClass('indicator');
                item.parent().append($indicator);
                var itemPosition = item.position();
                $indicator.data('top', item.find('img').position().top-24);
                $indicator.data('app',this);
                $indicator.css({
                  left:itemPosition.left+item.data('item').size[0]/2-16,
                  top:$indicator.data('top')
                });
                $.proxy(this.moveIndicatorUp, $indicator)();

              } else {
                if(this.gameState.markers.active == item[0]){
                  // cancel
              
                  
                } else {  
                  // shuffle stuff
                  this.shuffleItems($(this.gameState.markers.active), item);
                }
                this.gameState.markers.active = false;
                // remove indicator
                $('.indicator').stop().fadeOut(400, function(){
                  $(this).remove();
                });
              }
            },
            initItems:function(onInitComplete){
              var $app = this;
              this.gameState.markers = {};
              this.gameState.currentOrder = [];
              var container = $('#elements-container');
              var maxHeight = 0;
              var totalX = 0;
              for(var i=1;i<=this.currentSettings.currentLevel.items;i++){
                var itemData = this.elements[i];
                var $itemDiv = $('<div />').addClass('item');
                // attach indicator
                $itemDiv.data('item', itemData);
                $itemDiv.data('index', i);
                // set h and w
                $itemDiv.css({
                 //width:itemData.size[0]
                });
                if(itemData.size[1] > maxHeight){
                  maxHeight = itemData.size[1];
                }
                var $itemImage = $('<img />').attr({
                  src:itemData.file
                });
                totalX += itemData.size[0];
                $itemDiv.append($itemImage);
                $itemDiv.data('index', i);
                $mouseDiv = $('<div />').addClass('mouse-div');
                $mouseDiv.data('item', $itemDiv);
                $itemDiv.data('mouseDiv', $mouseDiv);

                container.append($itemDiv);
                container.append($mouseDiv);
                // create invisible mouseover element (for topping the hand marker)

                // $mouseDiv.on('mouseover', function(){                  
                  // $app.showMarkerOnItem($(this).data('item'));
                // });
                $itemDiv.on('click', function(){
                  $app.setActiveItem($(this));
                });
                // $mouseDiv.on('click', function(){                  
                  // $app.setMarkerOnItem($(this).data('item'));
                // });
                this.gameState.currentOrder.push($itemDiv[0]);
              }
              $('#elements-container .mouse-div').css({
                opacity:0
              });
              // set image Y
              $('#elements-container .item').each(function(){
                
                var $this = $(this);
                var $img = $this.find('img');
                $img.css({
                  top:maxHeight-$this.data('item').size[1]
                });
                // and put crates offscreen
                $this.css({
                  top:600
                });
              });
              $('#elements-container .item,#elements-container .mouse-div').css({
                height:maxHeight
              });
              // all attached
              // set Y
              this.setItemsTarget();
              // position items
              // center container
              container.data('width', totalX);
              container.data('height', maxHeight);
              container.css({
                top:350,
//                top:($('#app-container').height()-maxHeight)/2,
                left:($('#app-container').width()-totalX)/2,
              });
              // set init shuffle from level
              var level = this.currentSettings.currentLevel;
              var currentOrder = this.gameState.currentOrder;
              var levelOrderArray = [];
              $.each(level.order, function(){
                levelOrderArray = levelOrderArray.concat(currentOrder.slice(this-1,this));
              });
              this.gameState.currentOrder = levelOrderArray;
              this.setItemsTarget();
              this.animateItems(onInitComplete);

            },
            restartGame:function(){
              var $app = this;
              if(!this.gameState.levelStarted){
                  return false;
              }
              this.ui.killPopups();
              this.startLevel();
            },
            newGame:function(){
                this.ui.killPopups();
                this.container.find('#cutting-table').show();
                this.container.find('.splash').hide();
                this.currentSettings.currentLevel = this.levels[1];
                this.gameState.score = {
                  percent:0,
                  points:0
                };
                this.startLevel();
            },
            sounds:[],
            initSound:function(){
                this.sounds['slide'] = new Audio('sound/slide.ogg');
                this.sounds['click'] = new Audio('sound/button_50.ogg');
                this.sounds['click2'] = new Audio('sound/button_30.ogg');
                this.sounds['win'] = new Audio('sound/win.ogg');
                this.sounds['level_win'] = new Audio('sound/level_win.ogg');
                this.sounds['flip'] = new Audio('sound/button_16.ogg');
            },
            init:function(container){
                this.initSound();
                this.ui = new UIHelper();
                this.ui.app = this;
                this.ui.createColorSelector();
                this.api = new APIHelper();
                $('#color-back-layer').css({
                  backgroundColor:this.ui.backgroundColors[0]
                });
                this.ui.container = this.container = container;
                this.buildMenu();
                container.append(
                    $('<div />').html(
                        $('#app-splash').html()
                    ).addClass('splash')
                );
                this.loadSession();
                var $app = this;
//                this.container.append(this.progressBox);
                // arm sawing board
                // add empty overlay mouse detection layer
                this.container.find('.splash').hide();
            },
            showHighscore:function(){
                var $titledContainer = this.ui.titledContainer('Najlepsi z najlepszych');
                $titledContainer.attr('id','highscore-box');
                // construct hiscore table
                var $scoreTable = $('<table />').addClass('highscores');
                var $scoreTableHeader = $('<tr />').append('<th class=\'nick\'>Nick</th><th class=\'score\'>Wynik</th><th class=\'score\'>Wynik (%)</th>');
                $scoreTable.append($scoreTableHeader);
                var $app = this;
                this.api.getHighscores(function(r){
                    if(r){
                      var results = $(r).find('UserScore');
                      if(results.length){
                          $.each(results, function(){
                              var $scoreRow = $('<tr />');
                              var nick = this.getElementsByTagName('Nick')[0].childNodes[0].nodeValue;
                              var score = this.getElementsByTagName('Result')[0].childNodes[0].nodeValue;
                              var scorePercent = this.getElementsByTagName('ResultPercent')[0].childNodes[0].nodeValue;
                              $scoreRow.append('<td>'+nick+'</td><td>'+score+'</td><td>'+scorePercent+'</td>');
                              $scoreTable.append($scoreRow);
                          });
                      }
                    } else {
                      $scoreRow = $('<tr />').append($('<td>Nie udało się pobrać wyników.</td>').attr({
                        colspan:3,
                        align:'center'
                      }));
                      $scoreTable.append($scoreRow);
                    }
                    $app.ui.popupWindow($titledContainer,function(){});
                });
                
                
                $titledContainer.append($scoreTable);
                // TODO refactor
                // create menu items object in app
                
            },
            showCredits:function(){
                var $titledContainer = this.ui.titledContainer('Twórcy gry');
                $titledContainer.attr('id','credits-box');
                $titledContainer.append($('#app-credits').html());
                // TODO refactor
                // create menu items object in app
                this.ui.popupWindow($titledContainer,true);
            },            
            showHelp:function(){
                var $titledContainer = this.ui.titledContainer('Zasady gry');
                $titledContainer.attr('id','help-box');
                $titledContainer.append($('#app-help').html());
                // TODO refactor
                // create menu items object in app
                this.ui.popupWindow($titledContainer,true);
            },            
            buildMenu:function(){
                
                var $menuContainer = $('<div />').addClass('menu-container');
                var menuItems = [
                    {
                        label:'Pomoc',
                        onClick:$.proxy(this.showHelp,this),
                        css:'help'
                    },
                    {
                        label:'Najlepsi',
                        onClick:$.proxy(this.showHighscore,this),
                        css:'highscore'
                        
                    },
                    {
                        label:'Nowa gra',
                        onClick:$.proxy(this.newGame,this),
                        
                        css:'new-game'
                    },
                    {
                        label:'Restart',
                        onClick:$.proxy(this.restartGame,this),
                        css:'restart'
                    }
                ]
                var $app = this;
                $.each(menuItems, function(){
                    var $menuButton = $app.ui.buildButton(this.label, this.onClick, 'click');
                    if(this.css){
                      $menuButton.addClass(this.css);
                    }
                    $menuContainer.append($menuButton);
                });
                this.container.append($menuContainer);
                this.container.append(this.ui.buildButton("Twórcy", $.proxy(this.showCredits, this), 'click').addClass('small credits'));
            }
            
        }
    }

    $(document).on('ready', function(){
        app = new App();
        app.init($('#app-container #front-layer'));
    });
}(jQuery,CryptoJS));
